/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.commands;

import com.bcxin.Infrastructures.exceptions.TenantExceptionAbstract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public abstract class CommandAbstract {
    private final Collection<String> inValidatedLogs = new ArrayList<String>();

    public void validate() {
    }

    public void addError(String error) {
        this.inValidatedLogs.add(error);
    }

    public boolean IsValid() {
        return CollectionUtils.isEmpty(this.inValidatedLogs);
    }

    public String getErrorResult() {
        if (CollectionUtils.isEmpty(this.inValidatedLogs)) {
            return null;
        }
        return this.inValidatedLogs.stream().collect(Collectors.joining(","));
    }

    protected void checkParameter(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (TenantExceptionAbstract ex) {
            this.addError(ex.getMessage());
        }
    }

    public Collection<String> getInValidatedLogs() {
        return this.inValidatedLogs;
    }
}

