package com.bcxin.identity.domains.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.identity.domains.enums.EventAction;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;

@Getter
@Setter(AccessLevel.PROTECTED)
@Entity
@Table(name = "identity_user_events")
public class IdentityUserEventEntity extends EntityAbstract {
    @Id
    private String id;

    @Column(name = "created_time",nullable = false)
    private Timestamp createdTime;

    @Enumerated(EnumType.ORDINAL)
    private EventAction action;

    @Column(name = "content", length = 4000)
    private String content;

    @ManyToOne(cascade = CascadeType.DETACH)
    @JoinColumn(name = "identity_user_id", referencedColumnName = "id", nullable = false)
    private IdentityUserEntity identityUser;

    /**
     * 一定要设置为这个，否则保存的时候，系统会先去查找数据，找不到则会抛出异常JpaObjectRetrievalFailureException
     */
    @ManyToOne(cascade = CascadeType.DETACH)
    @JoinColumn(name = "principal_id", referencedColumnName = "id", nullable = true)
    private PrincipalAbstract principal;

    protected IdentityUserEventEntity(){}

    public static IdentityUserEventEntity create(EventAction eventAction, String content,
                                                 IdentityUserEntity identityUser,
                                                 PrincipalAbstract principal) {
        IdentityUserEventEntity identityUserEvent = new IdentityUserEventEntity();
        identityUserEvent.setId(UUID.randomUUID().toString());
        identityUserEvent.setCreatedTime(Timestamp.from(Instant.now()));
        identityUserEvent.setAction(eventAction);
        identityUserEvent.setContent(content);
        identityUserEvent.setIdentityUser(identityUser);
        identityUserEvent.setPrincipal(principal);

        return identityUserEvent;
    }
}
