/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OpEntityAbstract;
import com.bcxin.Infrastructures.enums.ProcessedStatus;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.tenant.domain.entities.EventSubscriberEntity;
import java.sql.Timestamp;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Table(name="tenant_event_subscribed_action_logs")
@Entity
public class EventSubscribedActionLogEntity
extends OpEntityAbstract
implements IAggregate {
    @Id
    private String id;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="status", nullable=false)
    private ProcessedStatus status;
    @Lob
    private String note;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;
    @ManyToOne
    private EventSubscriberEntity subscriber;
    @Column(name="ref_event_id", nullable=false)
    private String refEventId;
    @Column(name="ref_version", nullable=false)
    private Long refVersion;

    protected EventSubscribedActionLogEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static EventSubscribedActionLogEntity create(EventSubscriberEntity subscriber, String refEventId, Long refVersion, ProcessedStatus status, String note) {
        EventSubscribedActionLogEntity entity = new EventSubscribedActionLogEntity();
        entity.setId(UUIDUtil.getShortUuid());
        entity.setCreatedTime(Timestamp.from(Instant.now()));
        entity.setSubscriber(subscriber);
        entity.setRefEventId(refEventId);
        entity.setRefVersion(refVersion);
        entity.setStatus(status);
        entity.setNote(note);
        return entity;
    }

    public String getId() {
        return this.id;
    }

    public ProcessedStatus getStatus() {
        return this.status;
    }

    public String getNote() {
        return this.note;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public EventSubscriberEntity getSubscriber() {
        return this.subscriber;
    }

    public String getRefEventId() {
        return this.refEventId;
    }

    public Long getRefVersion() {
        return this.refVersion;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setStatus(ProcessedStatus status) {
        this.status = status;
    }

    protected void setNote(String note) {
        this.note = note;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setSubscriber(EventSubscriberEntity subscriber) {
        this.subscriber = subscriber;
    }

    protected void setRefEventId(String refEventId) {
        this.refEventId = refEventId;
    }

    protected void setRefVersion(Long refVersion) {
        this.refVersion = refVersion;
    }
}

