-- ----------------------------
-- Table structure for ferry_error_info
-- ----------------------------
DROP TABLE IF EXISTS `ferry_error_info`;
CREATE TABLE `ferry_error_info` (
   `id` bigint(20) NOT NULL COMMENT '主键id(文件id)',
   `ferry_task_id` bigint(20) DEFAULT NULL COMMENT '摆渡任务id',
   `ferry_file_id` bigint(20) DEFAULT NULL COMMENT '摆渡文件id',
   `receive_task_id` bigint(20) DEFAULT NULL COMMENT '接收任务id',
   `receive_file_id` bigint(20) DEFAULT NULL COMMENT '接收文件id',
   `error_message` varchar(255) DEFAULT NULL COMMENT '异常消息',
   `error_detail` mediumtext COMMENT '异常明细',
   `handle_status` tinyint(4) DEFAULT NULL COMMENT '处理状态，1-创建异常，2-已通知，3-已修复',
   `create_time` datetime DEFAULT NULL COMMENT '创建时间',
   `update_time` datetime DEFAULT NULL COMMENT '更新时间',
   PRIMARY KEY (`id`),
   KEY `index_ferry_error_info_ferry_task_id` (`ferry_task_id`) USING BTREE,
   KEY `index_ferry_error_info_ferry_file_id` (`ferry_file_id`) USING BTREE,
   KEY `index_ferry_error_info_receive_task_id` (`receive_task_id`) USING BTREE,
   KEY `index_ferry_error_info_receive_file_id` (`receive_file_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='摆渡异常信息表';

-- ----------------------------
-- Table structure for ferry_operate_log
-- ----------------------------
DROP TABLE IF EXISTS `ferry_operate_log`;
CREATE TABLE `ferry_operate_log` (
    `id` bigint(20) NOT NULL COMMENT '主键id',
    `task_id` bigint(20) DEFAULT NULL COMMENT '摆渡任务id',
    `operate_type` tinyint(4) DEFAULT NULL COMMENT '操作类型，1-创建任务，2-请求摆渡工具服务拉取数据接口，3-摆渡工具服务拉取数据完成，4-开始扫描摆渡文件，5-扫描摆渡文件完成，6-生成任务文件，7-请求边界服务接口，摆渡任务文件，8-任务文件摆渡成功，9-开始摆渡明细文件，10-摆渡明细文件完成',
    `create_time` datetime DEFAULT NULL COMMENT '创建时间',
    `update_time` datetime DEFAULT NULL COMMENT '更新时间',
    PRIMARY KEY (`id`),
    KEY `index_ferry_operate_log_task_id` (`task_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='摆渡操作日志表';

-- ----------------------------
-- Table structure for ferry_receive_operate_log
-- ----------------------------
DROP TABLE IF EXISTS `ferry_receive_operate_log`;
CREATE TABLE `ferry_receive_operate_log` (
            `id` bigint(20) NOT NULL COMMENT '主键id',
            `task_id` bigint(20) DEFAULT NULL COMMENT '接收任务id',
            `operate_type` tinyint(4) DEFAULT NULL COMMENT '操作类型，1-创建任务，2-解析任务文件，3-开始初始化任务信息，4-初始化任务信息完成，5-回调请求端，6-接收明细文件开始，7-接收明细文件完成，8-合并文件开始，9-合并文件完成，10-执行推送操作，11-摆渡完成',
            `create_time` datetime DEFAULT NULL COMMENT '创建时间',
            `update_time` datetime DEFAULT NULL COMMENT '更新时间',
            PRIMARY KEY (`id`),
            KEY `index_ferry_receive_operate_log_task_id` (`task_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='接收操作日志表';

-- ----------------------------
-- Table structure for ferry_receive_task
-- ----------------------------
DROP TABLE IF EXISTS `ferry_receive_task`;
CREATE TABLE `ferry_receive_task` (
     `id` bigint(20) NOT NULL COMMENT '主键id',
     `ferry_task_id` bigint(20) DEFAULT NULL COMMENT '摆渡任务id',
     `request_id` varchar(30) DEFAULT NULL COMMENT '请求id',
     `package_url` varchar(255) DEFAULT NULL COMMENT '摆渡包文件目录url',
     `file_total_count` int(11) DEFAULT NULL COMMENT '文件总数',
     `file_receive_count` int(11) DEFAULT NULL COMMENT '文件已接收总数',
     `task_status` tinyint(4) DEFAULT NULL COMMENT '接收任务状态，1-接收请求，2-解析任务文件，3-初始化任务信息，4-回调请求端，5-接收明细文件开始，6-接收明细文件完成，7-合并文件开始，8-合并文件完成，9-执行推送操作，10-摆渡完成，11-回调完成',
     `receive_result` mediumtext COMMENT '接收结果',
     `create_time` datetime DEFAULT NULL COMMENT '创建时间',
     `update_time` datetime DEFAULT NULL COMMENT '更新时间',
     PRIMARY KEY (`id`),
     KEY `index_ferry_receive_task_ferry_task_id` (`ferry_task_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='接收任务表';

-- ----------------------------
-- Table structure for ferry_receive_task_file
-- ----------------------------
DROP TABLE IF EXISTS `ferry_receive_task_file`;
CREATE TABLE `ferry_receive_task_file` (
          `id` bigint(20) NOT NULL COMMENT '主键id(文件id)',
          `task_id` bigint(20) DEFAULT NULL COMMENT '接收任务id',
          `file_type` tinyint(4) DEFAULT NULL COMMENT '文件类型，1-任务文件，2-sql文件，3-普通文件，4-子文件（拆分）',
          `file_name` varchar(255) DEFAULT NULL COMMENT '文件名称',
          `file_md5` varchar(50) DEFAULT NULL COMMENT '文件md5',
          `file_url` varchar(255) DEFAULT NULL COMMENT '文件存储url',
          `file_status` tinyint(4) DEFAULT NULL COMMENT '文件状态，1-初始化完成，2-接收完成',
          `file_size` decimal(15,2) DEFAULT NULL COMMENT '文件大小，kb',
          `is_split` tinyint(4) DEFAULT NULL COMMENT '是否拆分，1-是，0-否（是拆分的话，文件不摆渡）',
          `merge_status` tinyint(4) DEFAULT NULL COMMENT '合并状态，1-未合并，2-已合并',
          `split_file_ids` varchar(1000) DEFAULT NULL COMMENT '拆分文件的ids，,隔开',
          `receive_file_md5` varchar(50) DEFAULT NULL COMMENT '接收文件md5',
          `receive_result` mediumtext COMMENT '接收结果',
          `execute_status` tinyint(4) DEFAULT NULL COMMENT '执行状态，1-等待执行，2-执行中，3-执行完成',
          `create_time` datetime DEFAULT NULL COMMENT '创建时间',
          `update_time` datetime DEFAULT NULL COMMENT '更新时间',
          PRIMARY KEY (`id`),
          KEY `index_ferry_receive_task_file_task_id` (`task_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='接收任务文件表';

-- ----------------------------
-- Table structure for ferry_request_log
-- ----------------------------
DROP TABLE IF EXISTS `ferry_request_log`;
CREATE TABLE `ferry_request_log` (
    `id` bigint(20) NOT NULL COMMENT '主键id(文件id)',
    `task_id` bigint(20) DEFAULT NULL COMMENT '摆渡任务id',
    `file_id` bigint(20) DEFAULT NULL COMMENT '摆渡文件id',
    `api_url` varchar(255) DEFAULT NULL COMMENT '请求接口url',
    `request_param` mediumtext COMMENT '请求参数（不含文件）',
    `request_result` mediumtext COMMENT '请求结果',
    `api_return_time` datetime DEFAULT NULL COMMENT '接口返回时间',
    `boundary_task_id` varchar(100) DEFAULT NULL COMMENT '边界服务任务id',
    `ferry_status` tinyint(4) DEFAULT NULL COMMENT '摆渡状态，1-发送请求，2-返回边界任务id，3-摆渡成功',
    `success_time` datetime DEFAULT NULL COMMENT '摆渡成功时间',
    `create_time` datetime DEFAULT NULL COMMENT '创建时间',
    `update_time` datetime DEFAULT NULL COMMENT '更新时间',
    PRIMARY KEY (`id`),
    KEY `index_ferry_request_log_task_id` (`task_id`) USING BTREE,
    KEY `index_ferry_request_log_file_id` (`file_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='摆渡请求日志表';

-- ----------------------------
-- Table structure for ferry_task
-- ----------------------------
DROP TABLE IF EXISTS `ferry_task`;
CREATE TABLE `ferry_task` (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `request_id` varchar(50) DEFAULT NULL COMMENT '请求id',
  `region_code` varchar(50) DEFAULT NULL COMMENT '区域代码',
  `start_time` datetime DEFAULT NULL COMMENT '拉取开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '拉取结束时间',
  `package_url` varchar(255) DEFAULT NULL COMMENT '摆渡包文件目录url',
  `pull_result` mediumtext COMMENT '拉取结果',
  `file_total_count` int(11) DEFAULT NULL COMMENT '文件总数',
  `file_ferry_count` int(11) DEFAULT NULL COMMENT '文件已摆渡总数',
  `task_status` tinyint(4) DEFAULT NULL COMMENT '摆渡任务状态，1-开始拉取，2-拉取完成，3-扫描摆渡文件完成，4-生成任务文件完成，5-摆渡任务文件开始，6-摆渡任务文件完成，7-摆渡明细文件开始，8-摆渡明细文件结束，9-摆渡任务完成，-1-摆渡失败',
  `ferry_result` mediumtext COMMENT '摆渡结果',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='摆渡任务表';

-- ----------------------------
-- Table structure for ferry_task_file
-- ----------------------------
DROP TABLE IF EXISTS `ferry_task_file`;
CREATE TABLE `ferry_task_file` (
  `id` bigint(20) NOT NULL COMMENT '主键id(文件id)',
  `task_id` bigint(20) DEFAULT NULL COMMENT '摆渡任务id',
  `file_type` tinyint(4) DEFAULT NULL COMMENT '文件类型，1-任务文件，2-sql文件，3-普通文件，4-子文件（拆分）',
  `file_name` varchar(255) DEFAULT NULL COMMENT '文件名称',
  `file_md5` varchar(50) DEFAULT NULL COMMENT '文件md5',
  `file_url` varchar(255) DEFAULT NULL COMMENT '文件存储url',
  `file_status` tinyint(4) DEFAULT NULL COMMENT '文件状态，1-拉取完成，2-开始摆渡，3-摆渡完成，4-摆渡失败',
  `file_size` decimal(15,2) DEFAULT NULL COMMENT '文件大小，kb',
  `is_split` tinyint(4) DEFAULT NULL COMMENT '是否拆分，1-是，0-否（是拆分的话，文件不摆渡）',
  `split_file_ids` varchar(1000) DEFAULT NULL COMMENT '拆分文件的ids，,隔开',
  `boundary_task_id` varchar(100) DEFAULT NULL COMMENT '边界服务任务id',
  `ferry_result` mediumtext COMMENT '摆渡结果',
  `retry_count` int(11) DEFAULT NULL COMMENT '重试摆渡次数',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `index_ferry_task_file_task_id` (`task_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='摆渡任务文件表';