/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.comparator;

import cn.hutool.core.comparator.BaseFieldComparator;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;

public class FieldsComparator<T>
extends BaseFieldComparator<T> {
    private static final long serialVersionUID = 8649196282886500803L;
    private final Field[] fields;

    public FieldsComparator(Class<T> beanClass, String ... fieldNames) {
        this.fields = new Field[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            this.fields[i] = ClassUtil.getDeclaredField(beanClass, fieldNames[i]);
            if (this.fields[i] != null) continue;
            throw new IllegalArgumentException(StrUtil.format("Field [{}] not found in Class [{}]", fieldNames[i], beanClass.getName()));
        }
    }

    @Override
    public int compare(T o1, T o2) {
        for (Field field : this.fields) {
            int compare = this.compareItem(o1, o2, field);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

