package com.baichuanxin.openrestapi.service.impl;

import com.baichuanxin.openrestapi.dao.mapper.LicenseInformationMapper;
import com.baichuanxin.openrestapi.entity.LicenseInformation;
import com.baichuanxin.openrestapi.service.LicenseInformationService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.annotations.Update;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

@Slf4j
@Service
public class LicenseInformationServiceImpl extends ServiceImpl<LicenseInformationMapper, LicenseInformation> implements LicenseInformationService {
    @Override
    public boolean addLicenseInformation(LicenseInformation licenseInformation) {
        boolean result = this.save(licenseInformation);
        return result;
    }

    @Override
    public boolean updateLicenseInformation(LicenseInformation licenseInformation) {

        return false;
    }

    @Override
    public boolean updateStatusById(String id, String status) {
        UpdateWrapper<LicenseInformation>  updateWrapper  = new UpdateWrapper<>();
        updateWrapper.eq("id",id);
        updateWrapper.set("status",status);
        boolean result = this.update(updateWrapper);
        return result;
    }


    @Override
    public List<LicenseInformation> get(String status) {
        QueryWrapper<LicenseInformation> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("status",status);
        List<LicenseInformation> list = this.list(queryWrapper);
        return list;
    }

    @Override
    public List<LicenseInformation> getByUscc(String uscc) {
        QueryWrapper<LicenseInformation> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("uscc",uscc);
        List<LicenseInformation> list = this.list(queryWrapper);
        return list;
    }
}
