/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.enums.RecordStatus;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class AttendanceAdvanceCriteria
extends CriteriaAbstract {
    private final Collection<DeskType> deskTypes;
    private final String name;
    private final String companyName;
    private final String projectName;
    private final String projectCompanyName;
    private final String securityStationName;
    private final Collection<String> superviseDepartIds;
    private final Date createdStarDate;
    private final Date createdEndDate;
    private final String idCardNo;
    private final Collection<String> organizationIds;
    private final Collection<Integer> recordStatuses;
    private final Boolean hasSecurityCertificateNo;
    private Collection<String> otherSpecialPermissionScopeIds;
    private Collection<String> managedProjectIds;
    private boolean hasManagedProjectIds;
    private Integer calculatedResourceType;

    public AttendanceAdvanceCriteria(int pageIndex, int pageSize, Collection<DeskType> deskTypes, String name, String companyName, String projectName, String projectCompanyName, String securityStationName, Collection<String> superviseDepartIds, Date createdStarDate, Date createdEndDate, String idCardNo, Collection<String> organizationIds, Boolean hasSecurityCertificateNo, Collection<RecordStatus> recordStatuses, Collection<String> otherSpecialPermissionScopeIds, Integer calculatedResourceType, Collection<String> managedProjectIds) {
        super(pageIndex, pageSize);
        this.deskTypes = deskTypes;
        this.name = name;
        this.companyName = companyName;
        this.securityStationName = securityStationName;
        this.superviseDepartIds = superviseDepartIds;
        this.createdStarDate = createdStarDate;
        this.createdEndDate = createdEndDate;
        this.idCardNo = idCardNo;
        this.organizationIds = organizationIds;
        this.recordStatuses = CollectionUtils.isEmpty(recordStatuses) ? Collections.EMPTY_LIST : (Collection)recordStatuses.stream().map(ii -> ii.ordinal()).collect(Collectors.toList());
        this.hasSecurityCertificateNo = hasSecurityCertificateNo;
        this.otherSpecialPermissionScopeIds = otherSpecialPermissionScopeIds;
        this.calculatedResourceType = calculatedResourceType;
        this.projectName = projectName;
        this.projectCompanyName = projectCompanyName;
        this.managedProjectIds = managedProjectIds;
        this.hasManagedProjectIds = !CollectionUtils.isEmpty(this.managedProjectIds);
    }

    public static AttendanceAdvanceCriteria create(int pageIndex, int pageSize, Collection<DeskType> deskTypes, String name, String companyName, String projectName, String projectCompanyName, String securityStationName, Collection<String> superviseDepartIds, Date createdStarDate, Date createdEndDate, String idCardNo, Collection<String> organizationIds, Boolean hasSecurityCertificateNo, Collection<RecordStatus> recordStatuses, Collection<String> otherSpecialPermissionScopeIds, Integer calculatedResourceType, Collection<String> managedProjectIds) {
        return new AttendanceAdvanceCriteria(pageIndex, pageSize, deskTypes, name, companyName, projectName, projectCompanyName, securityStationName, superviseDepartIds, createdStarDate, createdEndDate, idCardNo, organizationIds, hasSecurityCertificateNo, recordStatuses, otherSpecialPermissionScopeIds, calculatedResourceType, managedProjectIds);
    }

    public Collection<DeskType> getDeskTypes() {
        return this.deskTypes;
    }

    public String getName() {
        return this.name;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectCompanyName() {
        return this.projectCompanyName;
    }

    public String getSecurityStationName() {
        return this.securityStationName;
    }

    public Collection<String> getSuperviseDepartIds() {
        return this.superviseDepartIds;
    }

    public Date getCreatedStarDate() {
        return this.createdStarDate;
    }

    public Date getCreatedEndDate() {
        return this.createdEndDate;
    }

    public String getIdCardNo() {
        return this.idCardNo;
    }

    public Collection<String> getOrganizationIds() {
        return this.organizationIds;
    }

    public Collection<Integer> getRecordStatuses() {
        return this.recordStatuses;
    }

    public Boolean getHasSecurityCertificateNo() {
        return this.hasSecurityCertificateNo;
    }

    public Collection<String> getOtherSpecialPermissionScopeIds() {
        return this.otherSpecialPermissionScopeIds;
    }

    public Collection<String> getManagedProjectIds() {
        return this.managedProjectIds;
    }

    public boolean isHasManagedProjectIds() {
        return this.hasManagedProjectIds;
    }

    public Integer getCalculatedResourceType() {
        return this.calculatedResourceType;
    }
}

