/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.util.ftp;

import com.bcxin.backend.core.exceptions.SaasRetryableException;
import com.bcxin.backend.core.utils.RetryUtil;
import com.bcxin.signature.util.ftp.FtpWriteConnection;
import com.bcxin.signature.util.ftp.FtpWriteFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FtpWriteUtil {
    private static final Logger logger = LoggerFactory.getLogger(FtpWriteUtil.class);

    public static boolean uploadBase64(String ftpPath, String ftpFileName, String base64Content) {
        boolean result = (Boolean)RetryUtil.execute(() -> {
            Boolean bl;
            FtpWriteConnection ftp = new FtpWriteConnection();
            try {
                bl = FtpWriteUtil.uploadBase64((FtpWriteConnection)ftp, (String)ftpPath, (String)ftpFileName, (String)base64Content);
            }
            catch (Exception ex) {
                try {
                    throw new SaasRetryableException(String.format("Retry with %s msg=%s", ftpFileName, ex.getMessage()), ex);
                }
                catch (Throwable throwable) {
                    try {
                        ftp.disconnect();
                        throw throwable;
                    }
                    catch (IOException e) {
                        logger.error("=======>\u91ca\u653e\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff08ftpPath={}, ftpFileName={}\uff09", new Object[]{ftpPath, ftpFileName, e});
                    }
                    throw throwable;
                }
            }
            try {
                ftp.disconnect();
                return bl;
            }
            catch (IOException e) {
                logger.error("=======>\u91ca\u653e\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff08ftpPath={}, ftpFileName={}\uff09", new Object[]{ftpPath, ftpFileName, e});
            }
            return bl;
        });
        return result;
    }

    public static List<String> filenames(String path, String keywork) {
        try {
            FtpWriteFactory factory = new FtpWriteFactory();
            FtpWriteConnection ftp = factory.getFtp();
            return ftp.fileNames(path, keywork);
        }
        catch (IOException e) {
            logger.error("filenames failed to get filename:{}", (Object)path, (Object)e);
            return new ArrayList<String>();
        }
    }

    public static boolean uploadBase64(FtpWriteConnection ftp, String ftpPath, String ftpFileName, String base64Content) {
        boolean result = false;
        try {
            result = ftp.uploadBase64(ftpPath, ftpFileName, base64Content);
        }
        catch (IOException e) {
            logger.error("=======>failed to upload base64 file ftp exception\uff08ftpPath={}, ftpFileName={}\uff09", new Object[]{ftpPath, ftpFileName, e});
        }
        return result;
    }
}

