/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.utils.ftp;

import com.bcxin.backend.domain.configs.FileModeConfig;
import com.bcxin.backend.domain.utils.ftp.FtpConnection;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpFactory {
    private static final Logger log = LoggerFactory.getLogger(FtpFactory.class);
    private static final ArrayBlockingQueue<FtpConnection> arrayBlockingQueue = new ArrayBlockingQueue(FileModeConfig.ftpConnectionSize);

    protected FtpFactory() {
        log.info("init ftpConnectionSize " + FileModeConfig.ftpConnectionSize);
        for (int i = 0; i < FileModeConfig.ftpConnectionSize; ++i) {
            arrayBlockingQueue.offer(new FtpConnection());
        }
    }

    public FtpConnection getFtp() {
        FtpConnection poll = null;
        try {
            poll = arrayBlockingQueue.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return poll;
    }

    public boolean relase(FtpConnection ftp) {
        return arrayBlockingQueue.offer(ftp);
    }

    public void remove(FtpConnection ftp) {
        arrayBlockingQueue.remove(ftp);
    }

    public void close() {
        for (FtpConnection connection : arrayBlockingQueue) {
            try {
                connection.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

