/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.push.android.oppo;

import cn.wildfirechat.push.PushMessage;
import cn.wildfirechat.push.Utility;
import cn.wildfirechat.push.android.oppo.OppoConfig;
import com.oppo.push.server.Notification;
import com.oppo.push.server.Result;
import com.oppo.push.server.Sender;
import com.oppo.push.server.Target;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OppoPush {
    private static final Logger LOG = LoggerFactory.getLogger(OppoPush.class);
    private static final int OPPO_PUSH_MAX_CONTENT = 200;
    @Autowired
    OppoConfig mConfig;
    private Sender mSender;

    @PostConstruct
    private void init() {
        try {
            this.mSender = new Sender(this.mConfig.getAppKey(), this.mConfig.getAppSecret());
        }
        catch (Exception e) {
            LOG.error("OppoPush init failed");
            e.printStackTrace();
        }
    }

    public void push(PushMessage pushMessage) {
        if (this.mSender == null) {
            LOG.error("Oppo push message can't sent, because not initial correctly");
        }
        Result result = null;
        try {
            Notification notification = this.getNotification(pushMessage);
            Target target = Target.build((String)pushMessage.deviceToken);
            result = this.mSender.unicastNotification(notification, target);
            result.getStatusCode();
            result.getReturnCode();
            result.getMessageId();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("sendSingle error " + e.getMessage());
        }
        if (result != null) {
            LOG.info("Server response: MessageId: " + result.getMessageId() + " ErrorCode: " + result.getReturnCode() + " Reason: " + result.getReason());
        }
    }

    private Notification getNotification(PushMessage pushMessage) {
        if (pushMessage.isHiddenDetail) {
            pushMessage.pushContent = "\u60a8\u6536\u5230\u4e00\u6761\u65b0\u6d88\u606f";
        }
        Notification notification = new Notification();
        String[] arr = Utility.getPushTitleAndContent((PushMessage)pushMessage);
        String title = arr[0];
        String body = arr[1];
        if (body != null && body.length() > 200) {
            body = body.substring(0, 197);
            body = body + "...";
        }
        notification.setTitle(title);
        notification.setContent(body);
        notification.setStyle(Integer.valueOf(1));
        notification.setShowTimeType(Integer.valueOf(0));
        if (pushMessage.pushMessageType != 0) {
            notification.setOffLineTtl(Integer.valueOf(60));
        } else {
            notification.setOffLineTtl(Integer.valueOf(600));
        }
        notification.setNetworkType(Integer.valueOf(0));
        return notification;
    }
}

