/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.push;

import cn.wildfirechat.push.PushMessage;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utility {
    private static final Logger LOG = LoggerFactory.getLogger(Utility.class);

    public static String[] getPushTitleAndContent(PushMessage pushMessage) {
        String body;
        String title;
        String pushContent = pushMessage.getPushContent();
        boolean hiddenDetail = pushMessage.isHiddenDetail;
        if (pushMessage.pushMessageType == 1) {
            pushContent = "\u901a\u8bdd\u9080\u8bf7";
            hiddenDetail = false;
        } else if (pushMessage.pushMessageType == 2) {
            pushContent = "\u901a\u8bdd\u7ed3\u675f";
            hiddenDetail = false;
        } else if (pushMessage.pushMessageType == 4) {
            pushContent = "\u5df2\u88ab\u5176\u4ed6\u7aef\u63a5\u542c";
            hiddenDetail = false;
        } else if (pushMessage.pushMessageType == 5) {
            pushContent = "\u6d88\u606f\u5df2\u88ab\u64a4\u56de";
            hiddenDetail = false;
            pushMessage.pushData = null;
        } else if (pushMessage.pushMessageType == 6) {
            pushContent = "\u6d88\u606f\u5df2\u88ab\u5220\u9664";
            hiddenDetail = false;
            pushMessage.pushData = null;
        } else if (pushMessage.pushMessageType == 7) {
            pushContent = "\u60a8\u6536\u5230\u4e00\u6761\u5bc6\u804a\u6d88\u606f";
        } else if (pushMessage.pushMessageType != 0) {
            LOG.error("not support push message type:{}", (Object)pushMessage.pushMessageType);
        }
        if (pushMessage.convType == 1) {
            title = pushMessage.targetName;
            if (StringUtils.isEmpty((Object)title)) {
                title = "\u7fa4\u804a";
            }
            body = StringUtils.isEmpty((Object)pushMessage.senderName) ? pushContent : pushMessage.senderName + ":" + pushContent;
            if (hiddenDetail) {
                body = "\u4f60\u6536\u5230\u4e00\u6761\u65b0\u6d88\u606f";
            }
            if (pushMessage.mentionedType == 1) {
                body = StringUtils.isEmpty((Object)pushMessage.senderName) ? "\u6709\u4eba\u5728\u7fa4\u91cc@\u4e86\u4f60" : pushMessage.senderName + "\u5728\u7fa4\u91cc@\u4e86\u4f60";
            } else if (pushMessage.mentionedType == 2) {
                body = StringUtils.isEmpty((Object)pushMessage.senderName) ? "\u6709\u4eba\u5728\u7fa4\u91cc@\u4e86\u5927\u5bb6" : pushMessage.senderName + "\u5728\u7fa4\u91cc@\u4e86\u5927\u5bb6";
            }
        } else if (pushMessage.convType == 3) {
            title = pushMessage.targetName;
            body = hiddenDetail ? "\u4f60\u6536\u5230\u4e00\u6761\u65b0\u6d88\u606f" : pushContent;
        } else {
            title = pushMessage.pushMessageType == 3 ? (StringUtils.isEmpty((Object)pushMessage.senderName) ? "\u597d\u53cb\u8bf7\u6c42" : pushMessage.senderName + " \u8bf7\u6c42\u52a0\u60a8\u4e3a\u597d\u53cb") : (StringUtils.isEmpty((Object)pushMessage.senderName) ? "\u6d88\u606f" : pushMessage.senderName);
            body = hiddenDetail ? "\u4f60\u6536\u5230\u4e00\u6761\u65b0\u6d88\u606f" : pushContent;
        }
        String[] result = new String[]{title, body};
        return result;
    }

    public static boolean filterPush(PushMessage pushMessage) {
        if (pushMessage.pushMessageType == 2) {
            if (Utility.shouldCancelVoipByePush((String)pushMessage.sender, (int)pushMessage.convType, (String)pushMessage.userId, (String)pushMessage.pushData)) {
                LOG.info("Voip bye push canceled");
                return true;
            }
        } else if (pushMessage.pushMessageType == 4 && Utility.shouldCancelVoipAnswerPush((String)pushMessage.sender, (String)pushMessage.userId)) {
            LOG.info("Voip answer push canceled");
            return true;
        }
        return false;
    }

    private static boolean shouldCancelVoipByePush(String sender, int conversationType, String recvId, String pushData) {
        int reason;
        block8: {
            if (sender.equals(recvId)) {
                return true;
            }
            reason = -1;
            if (!StringUtils.isEmpty((Object)pushData)) {
                try {
                    JSONObject object = (JSONObject)new JSONParser().parse(pushData);
                    Object oEndReason = object.get((Object)"r");
                    if (oEndReason == null) break block8;
                    if (oEndReason instanceof Integer) {
                        reason = (Integer)oEndReason;
                    } else if (oEndReason instanceof Long) {
                        long lr = (Long)oEndReason;
                        reason = (int)lr;
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else {
                return false;
            }
        }
        LOG.info("End call reason is {}, convType is {}", (Object)reason, (Object)conversationType);
        return reason <= 0 || !(conversationType == 0 ? reason == 3 || reason == 11 : conversationType == 1 && reason == 9);
    }

    private static boolean shouldCancelVoipAnswerPush(String sender, String recvId) {
        return !sender.equals(recvId);
    }
}

