package cn.wildfirechat.push.android.getui;


import cn.wildfirechat.push.PushMessage;
import cn.wildfirechat.push.PushMessageType;
import cn.wildfirechat.push.Utility;
import cn.wildfirechat.push.android.xiaomi.XiaomiConfig;
import com.getui.push.v2.sdk.ApiHelper;
import com.getui.push.v2.sdk.GtApiConfiguration;
import com.getui.push.v2.sdk.api.PushApi;
import com.getui.push.v2.sdk.common.ApiResult;
import com.getui.push.v2.sdk.dto.req.Audience;
import com.getui.push.v2.sdk.dto.req.Settings;
import com.getui.push.v2.sdk.dto.req.Strategy;
import com.getui.push.v2.sdk.dto.req.message.PushChannel;
import com.getui.push.v2.sdk.dto.req.message.PushDTO;
import com.getui.push.v2.sdk.dto.req.message.android.AndroidDTO;
import com.getui.push.v2.sdk.dto.req.message.android.GTNotification;
import com.getui.push.v2.sdk.dto.req.message.android.ThirdNotification;
import com.getui.push.v2.sdk.dto.req.message.android.Ups;
import com.getui.push.v2.sdk.dto.req.message.ios.Alert;
import com.getui.push.v2.sdk.dto.req.message.ios.Aps;
import com.getui.push.v2.sdk.dto.req.message.ios.IosDTO;
import com.google.gson.Gson;
import com.meizu.push.sdk.server.IFlymePush;
import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.Message;
import com.xiaomi.xmpush.server.Result;
import com.xiaomi.xmpush.server.Sender;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import static com.xiaomi.xmpush.server.Message.NOTIFY_TYPE_ALL;

@Component
public class GetuiPush {
    private static final Logger LOG = LoggerFactory.getLogger(GetuiPush.class);
    @Autowired
    private GetuiConfig mConfig;

    private PushApi pushApi;

    @PostConstruct
    public void init() {
        try{
            // 设置httpClient最大连接数，当并发较大时建议调大此参数。或者启动参数加上 -Dhttp.maxConnections=200
            System.setProperty("http.maxConnections", "200");
            GtApiConfiguration apiConfiguration = new GtApiConfiguration();
            //填写应用配置
            if(!StringUtils.isEmpty(mConfig.getAppId())) {
                apiConfiguration.setAppId(mConfig.getAppId());
                apiConfiguration.setAppKey(mConfig.getAppKey());
                apiConfiguration.setMasterSecret(mConfig.getMasterSecret());
                // 接口调用前缀，请查看文档: 接口调用规范 -> 接口前缀, 可不填写appId
                apiConfiguration.setDomain("https://restapi.getui.com/v2/");
    //        apiConfiguration.setDomain(mConfig.getDomain());
                // 实例化ApiHelper对象，用于创建接口对象
                ApiHelper apiHelper = ApiHelper.build(apiConfiguration);
                // 创建对象，建议复用。目前有PushApi、StatisticApi、UserApi
                this.pushApi = apiHelper.creatApi(PushApi.class);
            }
        } catch (Exception e) {
            LOG.error("GetuiPush init failed");
            e.printStackTrace();
        }
    }

    public void push(PushMessage pushMessage, boolean isAndroid) {
        String[] arr = Utility.getPushTitleAndContent(pushMessage);
        String title = arr[0];
        String body = arr[1];

        //根据cid进行单推
        PushDTO<Audience> pushDTO = new PushDTO<Audience>();
        // 设置推送参数
        pushDTO.setRequestId(System.currentTimeMillis() + "");
        /**** 设置个推通道参数 *****/
        com.getui.push.v2.sdk.dto.req.message.PushMessage pm = new com.getui.push.v2.sdk.dto.req.message.PushMessage();
        pushDTO.setPushMessage(pm);
        Settings settings = new Settings();
        pushDTO.setSettings(settings);
        settings.setTtl(3 * 24 * 3600 * 1000);
        Strategy strategy = new Strategy();
        settings.setStrategy(strategy);
        strategy.setDef(1);

//        pm.setTransmission(body);
        GTNotification notification = new GTNotification();
        pm.setNotification(notification);
        notification.setTitle(title);
        notification.setBody(body);
        notification.setClickType("startapp");
//        notification.setUrl("https://www.getui.com");
        /**** 设置个推通道参数，更多参数请查看文档或对象源码 *****/

        /**** 设置厂商相关参数 ****/
        PushChannel pushChannel = new PushChannel();
        pushDTO.setPushChannel(pushChannel);
        /*配置安卓厂商参数*/
        AndroidDTO androidDTO = new AndroidDTO();
        pushChannel.setAndroid(androidDTO);
        Ups ups = new Ups();
        androidDTO.setUps(ups);
        ThirdNotification thirdNotification = new ThirdNotification();
        ups.setNotification(thirdNotification);
        thirdNotification.setTitle(title);
        thirdNotification.setBody(body);
        thirdNotification.setClickType("startapp");
//        thirdNotification.setUrl("https://www.getui.com");
        // 两条消息的notify_id相同，新的消息会覆盖老的消息，取值范围：0-2147483647
        // thirdNotification.setNotifyId("11177");

        Map<String, Map<String, Object>> options = new HashMap<>();
        Map<String, Object> hw = new HashMap<>();
        hw.put("/message/android/category","VOIP");// 自分类权益 VOIP音视频通话
        hw.put("/message/android/notification/default_sound",false);// 设置为 false，使用sound自定义铃声
        hw.put("/message/android/notification/sound","/raw/pushsound");// TODO 自定义消息通知铃声，在新创建渠道时有效，此处设置的铃声文件必须存放在应用的/res/raw路径下
        options.put("HW",hw);

        Map<String, Object> xm = new HashMap<>();
        xm.put("/extra.sound_uri","android.resource://com.bcxin.bbdhn/raw/pushsound");// TODO 小米后台申请的自定义sound_url地址
        xm.put("/extra.channel_id","109448");// TODO 小米后台申请的"私信"通知类别id
        options.put("XM",xm);

        Map<String, Object> vv = new HashMap<>();
        vv.put("/category","IM");// TODO 二级分类
        options.put("VV",vv);

        Map<String, Object> op = new HashMap<>();
        op.put("/channel_id","__UNI__359FBBE__01");// OPush平台上所有通道分为“公信”(默认)、“私信”两类，默认下发公信消息。公信消息单日可推送数量有限制，私信消息不限(仅限单个用户)
        options.put("OPG",op);// TODO 当前配置的 公信 通道，每日有推送数量限制，私信通道：OPG

        Map<String, Object> _ups = new HashMap<>();
        _ups.put("bigText",title+"<br>"+pushMessage.pushContent);// 通知展示文本+长文本样式的长文本内容
        options.put("UPS",_ups);

        ups.setOptions(options);

        /*配置安卓厂商参数结束，更多参数请查看文档或对象源码*/

        /*设置ios厂商参数*/
        IosDTO iosDTO = new IosDTO();
        pushChannel.setIos(iosDTO);
        if (pushMessage.pushMessageType == 1 || pushMessage.pushMessageType == 2) {
            iosDTO.setType("voip");
        }
        // 相同的collapseId会覆盖之前的消息
        iosDTO.setPayload(pushMessage.pushContent);
        iosDTO.setAutoBadge("+1");
        iosDTO.setApnsCollapseId("" + pushMessage.messageId);
        Aps aps = new Aps();
        iosDTO.setAps(aps);
        aps.setSound("pushsound.caf");
        aps.setCategory("ACTIONABLE");
        Alert alert = new Alert();
        aps.setAlert(alert);
        alert.setTitle(title);
        alert.setBody(body);
        /*设置ios厂商参数结束，更多参数请查看文档或对象源码*/

        /*设置接收人信息*/
        Audience audience = new Audience();
        pushDTO.setAudience(audience);
        audience.addCid(pushMessage.getDeviceToken());
        /*设置接收人信息结束*/
        /**** 设置厂商相关参数，更多参数请查看文档或对象源码 ****/

        // 进行cid单推
        LOG.info("cid单推，cid：：" + audience.getCid());
        LOG.info("个推参数：：" + new Gson().toJson(pushDTO));
        ApiResult<Map<String, Map<String, String>>> apiResult = pushApi.pushToSingleByCid(pushDTO);
        if (apiResult.isSuccess()) {
            // success
            LOG.info("success：" + new Gson().toJson(apiResult));
        } else {
            // failed
            LOG.info("code:" + apiResult.getCode() + ", msg: " + apiResult.getMsg());
        }
    }
}
