package com.bcxin.risk.user.dto.data;

import lombok.Data;

import java.util.Map;

/**
 * 简单的集合
 */
@Data
public class UserPlainDataDTO {


	private String phone;

	private String oid; // 用户ID

	private String realName; //真实姓名

	/**
	 * 头衔
	 */
	private String expertCategory;

	public UserPlainDataDTO(Map<String,Object> map){
		this.oid = safeTransfor(map.get("oid"));
		this.realName = safeTransfor(map.get("realName"));
		this.expertCategory = safeTransfor(map.get("expertCategory"));
		this.phone = safeTransfor(map.get("phone"));
	}

	private String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}

}
	
