package com.bcxin.risk.user.domain;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bcxin.risk.org.domain.Company;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * 管理机构
 */
@Entity
@Table(name = "RISK_CompanyUser")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties({"hibernateLazyInitializer", "handler"})
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class CompanyUser extends User {

	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = Company.class, fetch = FetchType.EAGER)
	@JoinColumn(name = "company_id")
	@JsonIgnoreProperties
	private Company company;

	private String superAdmin; // 超级管理员标志

}
