package com.bcxin.risk.surveytk.enums;

/**
 * @author hzp
 * 踏勘任务审批状态
 */
public enum ApprovalStatusEnum {

    NON("NON","未审批"),
    NOTPASS("NOTPASS","拒绝"),
    PASS("PASS","同意"),
    CLOSE("CLOSE","关闭");

    private String key;
    private String alias;

    ApprovalStatusEnum(String key, String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(ApprovalStatusEnum e : ApprovalStatusEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
