package com.bcxin.risk.surveytk.domain.dto;

import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.surveytk.enums.AcceptStatusEnum;
import com.bcxin.risk.surveytk.enums.ApprovalStatusEnum;
import com.bcxin.risk.surveytk.enums.AssistTypeEnum;
import com.bcxin.risk.surveytk.enums.TaskStatusEnum;
import lombok.Data;

import java.util.Map;

/**
 * @author hzp
 * 踏勘协助列表查询字段
 */
@Data
public class SurveyAssistDataDto {
    private Page page;

    /**
     * 主键
     */
    private String oid;

    /**
     * 申请原因
     */
    private String applyReason;

    /**
     * 协助类型
     */
    private String assistType;

    /**
     * 协助类型名称
     */
    private String assistTypeName;

    /**
     * 审批状态
     */
    private String approvalStatus;

    /**
     * 审批状态名称
     */
    private String approvalStatusName;

    /**
     * 申请时间
     */
    private String applyDate;

    /**
     * 专家
     */
    private String experts;

    /**
     * 任务id
     */
    private String taskId;

    /**
     * 申请人id
     */
    private String applyUserId;

    /**
     * 申请人名称
     */
    private String applyUserName;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 是否加急
     */
    private String reportUrgent;

    public SurveyAssistDataDto(){

    }
    public SurveyAssistDataDto(Map<String,Object> map){
        this.oid = safeTransfor(map.get("oid"));
        this.applyReason=safeTransfor(map.get("applyReason"));
        this.activityName=safeTransfor(map.get("activityName"));
        this.assistType=safeTransfor(map.get("assistType"));
        this.assistTypeName=AssistTypeEnum.getAlias(safeTransfor(map.get("assistType")));
        this.approvalStatus=safeTransfor(map.get("approvalStatus"));
        this.approvalStatusName=ApprovalStatusEnum.getAlias(safeTransfor(map.get("approvalStatus")));
        this.applyDate=safeTransfor(map.get("applyDate"));
        this.experts=safeTransfor(map.get("experts"));
        this.taskId=safeTransfor(map.get("taskId"));
        this.applyUserId=safeTransfor(map.get("applyUserId"));
        this.applyUserName=safeTransfor(map.get("applyUserName"));
        this.reportUrgent=safeTransfor(map.get("reportUrgent"));
    }

    private String safeTransfor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }
}
