package com.bcxin.risk.survey.domain;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.activity.Venue;
import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;

import javax.persistence.*;

/**
 * 整改意见
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_Survey_Rectification")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
public class Survey_Rectification extends BaseBean {

	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activity_id")
	private Activity activity;
	
	private String surveyStep;//勘查阶段 (字典)
	
	@ManyToOne(targetEntity = Venue.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "venue_id")
    private Venue venue = new Venue();
	
	private String beginDate;
	
	private String endDate;
	
	private String contactName;
	
	private String contactPhone;
	
	private String surveyReport;
	
	private String correction = "0";
	

}
