package com.bcxin.risk.report.material.domain;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;


/**
 * <b>Function </b>客户上传的数据，活动材料的模块，用户自行选择是和否
 * 
 * @author LuoPeng
 * @date 2017年1月5日 下午5:39:12
 * @注意事项 </b>
 * <b>
 */
@Entity
@Table(name = "RISK_MaterialFormModule")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class MaterialFormModule extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**  对应的活动*/
	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activity_id")
	private Activity activity;

	private String materialModule;

	private String value;

}
