package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * @author LeeJungHyun
 * 承办活动的规模
 **/
public enum ProjectScale {
	THOUSANDS {
		public String getValue(){return "0";}
		public String getName(){return "1000人-2000人";}
	},OTHER {
		public String getValue(){return "6";}
		public String getName(){return "其他";}
	};
	
	 public abstract String getValue();
	 public abstract String getName();
	 
	 public static ProjectScale convert(String value){
	    	if ( "THOUSANDS".equals(value) ) {
	    		return ProjectScale.THOUSANDS;
	    	} 
	    	return ProjectScale.OTHER;
	    }
	 
	 /**
	  * 保众网类型转换
	  * @param idType
	  * @return
	  */
	 public static String convert_bzw(ProjectScale projectType){
		String return_code = "";
		switch (projectType) {
		case THOUSANDS:
			return_code = "0";
			break;
	
		default:
			break;
		}
		 return return_code;
	 }
	 public static List<ProjectScale> list(){
	    	List<ProjectScale> list = new ArrayList<ProjectScale>();
	    	list.add(THOUSANDS);
	    	list.add(OTHER);
	    
	    	return list;
	    }
}
