package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;


public enum InvoiceStatus {
	
	NULL{public String getValue(){return "0";} public String getName(){return "无需发票";}},
	
	NOACTIVE{public String getValue(){return "1";} public String getName(){return "未开发票";}},
	
	ACTIVE {public String getValue(){return "2";} public String getName(){return "已开发票";}};
	
    public abstract String getValue();
    
    public abstract String getName();


    public static InvoiceStatus convert_value(String value){
    	if ( "0".equals(value) ) {
    		return InvoiceStatus.NULL;
    	} else if ("1".equals(value)) {
    		return InvoiceStatus.NOACTIVE;
    	} else if ("2".equals(value)) {
    		return InvoiceStatus.ACTIVE;
    	} 
    	return null;
    }
    
    public  static List<InvoiceStatus> list(){
    	List<InvoiceStatus> list = new ArrayList<InvoiceStatus>();
    	list.add(NOACTIVE);
    	list.add(ACTIVE);
    	return list;
    }

}
