package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

public enum DedecmsType {

	ch192425{
		public String getValue(){return "1";}
		public String getName(){return "dede_addon192425";}//室外场地
		public String getCName(){return "室外场地";}//室外场地
		public String getArctype(){return "165";}
		public String getChannel(){return "25";}
	},
	ch1924{
		public String getValue(){return "2";}
		public String getName(){return "dede_addon1924";}//会展场馆总体信息模板
		public String getCName(){return "会展场馆总体信息";}//会展场馆总体信息模板
		public String getArctype(){return "169";}
		public String getChannel(){return "24";}
	},
	ch30{
		public String getValue(){return "3";}
		public String getName(){return "dede_addon30";}//会展场馆展厅信息模板
		public String getCName(){return "会展场馆展厅信息模板";}//会展场馆展厅信息模板
		public String getArctype(){return "170";}
		public String getChannel(){return "30";}
	},
	ch19{
		public String getValue(){return "4";}
		public String getName(){return "dede_addon19";}//体育场馆
		public String getCName(){return "体育场馆";}//体育场馆
		public String getArctype(){return "166";}
		public String getChannel(){return "19";}
	};
	
	public abstract String getValue();
	public abstract String getName();
	public abstract String getCName();
	public abstract String getArctype();
	public abstract String getChannel();
	
	public static DedecmsType convert(String value){
    	if ( "1".equals(value) ) {
    		return DedecmsType.ch192425;
    	} else if ("2".equals(value)) {
    		return DedecmsType.ch1924;
    	}else if ("3".equals(value)) {
    		return DedecmsType.ch19;
    	}else if ("4".equals(value)) {
    		return DedecmsType.ch30;
    	}
    	return null;
    }
    
	public static DedecmsType convertName(String name){
    	if ( "ch192425".equals(name) ) {
    		return DedecmsType.ch192425;
    	} else if ("ch1924".equals(name)) {
    		return DedecmsType.ch1924;
    	}else if ("ch19".equals(name)) {
    		return DedecmsType.ch19;
    	}else if ("ch30".equals(name)) {
    		return DedecmsType.ch30;
    	}
    	return null;
    }
   
    public static List<DedecmsType> list(){
    	List<DedecmsType> list = new ArrayList<DedecmsType>();
    	//list.add(City.GUOWUYUAN);
      	list.add(DedecmsType.ch192425);
    	list.add(DedecmsType.ch19);
      	list.add(DedecmsType.ch1924);
    	list.add(DedecmsType.ch30);

    	return list;
    }
}
