package com.bcxin.risk.report.dto.data;

import lombok.Data;

import java.util.Map;

/**
 * <b>Function </b> 客户上传的值，dto
 * 
 * @author LuoPeng
 * @date 2017年1月11日 上午11:06:35
 * @注意事项 </b> <b>
 */
@Data
public class MaterialFormValueDTO {

	private String oid;

	private String attrId;
	
	private String attrCode;

	private String attrName;

	private String attrHidden;

	private String attrType;

	private String optionType;

	private String orgId;

	private String menuCode;

	private String menuName;

	private String seq;

	private String value;

	private String modify;

	public MaterialFormValueDTO() {

	}

	public MaterialFormValueDTO(Map<String, Object> map) {
		this.oid = safeTransfor(map.get("oid"));
		this.attrId = safeTransfor(map.get("attrId"));
		this.attrCode = safeTransfor(map.get("attrCode"));
		this.attrName = safeTransfor(map.get("attrName"));
		this.attrHidden = safeTransfor(map.get("attrHidden"));
		this.attrType = safeTransfor(map.get("attrType"));
		this.optionType = safeTransfor(map.get("optionType"));
		this.menuName = safeTransfor(map.get("menuName"));
		this.orgId = safeTransfor(map.get("orgId"));
		this.menuCode = safeTransfor(map.get("menuCode"));
		this.seq = safeTransfor(map.get("seq"));
		this.value = safeTransfor(map.get("value"));
		this.modify = safeTransfor(map.get("modify"));
	}

	/**
	 * 
	 * <b>Function 将Object安全转换为String</b>
	 * 
	 * @param obj
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月22日 下午5:17:02
	 * @注意事项 </b> <b>
	 */
	private String safeTransfor(Object obj) {
		if (obj == null) {
			return "";
		}
		return obj.toString();
	}

}
