package com.bcxin.risk.policy.enums;

/**
 * @author LeeJungHyun
 **/
public enum SettlementStatus {

	NO_SETTLEMENT(1, "未结算"),
	// 已结算
	SETTLEMENTED(2, "已结算"),
	// 已转账
	TRANSFERACCOUNT(3, "已转账");

	private SettlementStatus(Integer code, String description) {
		this.code = code;
		this.description = description;
	}

	private Integer code;
	private String description;

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public static SettlementStatus getStatus(String value){
		if("1".equals(value)){
			return SettlementStatus.NO_SETTLEMENT;
		}else if("2".equals(value)){
			return SettlementStatus.SETTLEMENTED;
		}else if("3".equals(value)){
			return SettlementStatus.TRANSFERACCOUNT;
		}
		return null;
	}

	public static SettlementStatus convert(String name){
		if ("NO_SETTLEMENT".equals(name)) {
			return NO_SETTLEMENT;
		}if ("SETTLEMENTED".equals(name)) {
			return SETTLEMENTED;
		}if ("TRANSFERACCOUNT".equals(name)) {
			return TRANSFERACCOUNT;
		}
		return NO_SETTLEMENT;
	}


}
