package com.bcxin.risk.policy.enums;

/**
 * @author LeeJungHyun
 **/
public enum IdType {
	IDCARD {
		public String getValue(){return "0";}
		public String getName(){return "身份证";}
	},OFFICERCERTIFICATE {
		public String getValue(){return "1";}
		public String getName(){return "军官证";}
	},PASSPORT {
		public String getValue(){return "2";}
		public String getName(){return "护照";}
	},CARLICENCE {
		public String getValue(){return "3";}
		public String getName(){return "驾驶执照";}
	},HVPSANDMTP {
		public String getValue(){return "4";}
		public String getName(){return "港澳回乡证或台胞证";}
	},HOMECARD {
		public String getValue(){return "5";}
		public String getName(){return "返乡证";}
	},OTHER {
		public String getValue(){return "6";}
		public String getName(){return "其他";}
	},BUSINESSLICENSE{
		public String getValue(){return "7";}
		public String getName(){return "营业执照";}
	},TAXREGISTRATIONCERTIFICATE{
		public String getValue(){return "8";}
		public String getName(){return "税务登记证";}
	},ORGANIZATIONCODECERTIFICATE{
		public String getValue(){return "9";}
		public String getName(){return "组织机构代码证";}
	};
	
	 public abstract String getValue();
	 public abstract String getName();
	 
	 public static IdType convert(String value){
	    	if ("7".equals(value)) {
	    		return IdType.BUSINESSLICENSE;
	    	} else if ("8".equals(value)) {
	    		return IdType.TAXREGISTRATIONCERTIFICATE;
	    	} else if ("9".equals(value)) {
	    		return IdType.ORGANIZATIONCODECERTIFICATE;
	    	}
	    	return IdType.OTHER;
	    }
	 
	 /**
	  * 保众网类型转换
	  * @param idType
	  * @return
	  */
	 public static String convert_bzw(IdType idType){
		String return_code = "";
		switch (idType) {
		case IDCARD:
			return_code = "0";
			break;
		case OFFICERCERTIFICATE:
			return_code = "1";
			break;
		case PASSPORT:
			return_code = "2";
			break;	
		case CARLICENCE:
			return_code = "3";
			break;
		case HVPSANDMTP:
			return_code = "4";
			break;
		case HOMECARD:
			return_code = "6";
			break;
		case OTHER:
			return_code = "5";
			break;
		default:
			break;
		}
		 return return_code;
	 }
}
