package com.bcxin.risk.policy.domain;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.policy.enums.InsuranceCompany;
import com.bcxin.risk.policy.enums.ProductGroupType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

import javax.persistence.*;

/**
 * 产品模型
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_InsuranceProduct")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer"})
@Data
public class InsuranceProduct extends BaseBean {
	
	private static final long serialVersionUID = 1L;

	@Enumerated(EnumType.STRING)
	private ProductGroupType groupType;
	
	private String name;
	private String suggest;//购买建议
//	private String description;//描述
	
	private String minProductPrice;//最小产品价格
	private String minProductPriceUnit;//最小产品价格单位
	
	private String productRule; //投保规则
	
	private String description;//描述

	private String externalReference;// 电商产品代码

	private String  coreCode; // 保险公司产品代码
	private String  coreName; // 保险公司产品名称
	private String  productType;
	
	/** 保险产品对应的类型   默认为展览类型*/

	private String activityType ;

	@Enumerated(EnumType.STRING)
	private InsuranceCompany insuranceCompany;//对应保险公司

	private boolean active = false; //上架、下架


}
