package com.bcxin.risk.policy.domain;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.policy.enums.InsuranceCompany;

/**
 * 保障责任
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_DutySpec")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class DutySpec extends BaseBean{

	private static final long serialVersionUID = 1L;

	private String name;
	private String externalReference;//责任代码
	private String description;//责任描述
	
	@Enumerated(EnumType.STRING)
	private InsuranceCompany insuranceCompany;//保险公司


}
