package com.bcxin.risk.org.dto;

import com.bcxin.risk.org.domain.InvoiceTemplate;
import lombok.Data;

@Data
public class InvoiceTemplateDto {

    //------------收件地址------------
    private String recipientName;//收件人姓名
    private String recipientPhone;//收件人电话
    private String recipientAddress;//收件人地址
    //------------收件地址------------

    private String approveActive; //审核结果（见字典)

    private String ticketName;//收票人姓名
    private String ticketPhone;//收票人电话
    private String ticketAddress;//收票人地址
    private String invoiceTitle;

    private String companyName;// 公司单位
    private String taxpayerNumber; // 纳税人识别号
    private String registerAddress;// 注册地址
    private String contactPhone;
    private String bank;
    private String bankAccount;
    private String remark;//哪个审核结果出错了

    private String tax_cert;// 税务登记证
    private String tax_cert_thumbnail;// 税务登记证
    private String tax_cert_name;// 名字

    private String tax_prove;// 一般纳税人证明
    private String tax_prove_thumbnail;
    private String tax_prove_name;// 名字

    private String bank_licence;// 银行开户许可证
    private String bank_licence_thumbnail;
    private String bank_licence_name;// 名字

    private String business_license;// 营业执照副本
    private String business_license_thumbnail;
    private String business_license_name;// 名字

    private String auth_cert;// 增票授权委托书
    private String auth_cert_thumbnail;
    private String auth_cert_name;

    public InvoiceTemplateDto(){}

    public InvoiceTemplateDto(InvoiceTemplate invoiceTemplate){

        this.ticketName = invoiceTemplate.getTicketName();
        this.ticketPhone = invoiceTemplate.getTicketPhone();
        this.ticketAddress = invoiceTemplate.getTicketAddress();
        this.invoiceTitle = invoiceTemplate.getInvoiceTitle();
        this.companyName = invoiceTemplate.getCompanyName();
        this.taxpayerNumber = invoiceTemplate.getTaxpayerNumber();
        this.registerAddress = invoiceTemplate.getRegisterAddress();
        this.contactPhone = invoiceTemplate.getContactPhone();
        this.bank = invoiceTemplate.getBank();
        this.bankAccount = invoiceTemplate.getBankAccount();
        this.tax_cert = invoiceTemplate.getTax_cert();

    }
}
