package com.bcxin.risk.org.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;

import javax.persistence.*;
import java.util.Date;

/**
 * 服务机构业务范围
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_ServiceOrgMarket")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ServiceOrgMarket extends BaseBean {

	private static final long serialVersionUID = 1L;

	@OneToOne(targetEntity = ServiceOrg.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "serviceOrg_id")
	private ServiceOrg serviceOrg;//对应的服务机构

	@Type(type="text")
	private String region;//支持的区域，保存code

	private Date validDate;//有效开始日期

	private Date expiredDate;//失效日期

}
