package com.bcxin.risk.order.dto;

import lombok.Data;

import java.util.Map;

/**
 * 交易
 *
 */
  @Data
  public class TransactionDataDto {
	   private String payTime;
	   private String org;  //支付机构名
	   private String payOrderNo; //线上支付账户
	   private String amount ;
	   private String payAccount ;
	   private String payVoucher; //支付凭证路径
	   private String product;
	   private String paymentType; //支付状态：支付宝，银联，微信
	   private String paymentMode ;//支付方式：线上，线下


	  public TransactionDataDto(Map<String,Object> map){
		this.payTime = safeTransfor(map.get("payTime"));
		this.org = safeTransfor(map.get("org"));
		this.payAccount = safeTransfor(map.get("payAccount"));
		this.payOrderNo = safeTransfor(map.get("payOrderNo"));
		this.amount = safeTransfor(map.get("amount"));
		this.payVoucher = safeTransfor(map.get("payVoucher"));
		this.product = safeTransfor(map.get("product"));
		this.paymentType = safeTransfor(map.get("paymentType"));
		this.paymentMode = safeTransfor(map.get("paymentMode"));
	  }

	   private String safeTransfor(Object obj){
		  if ( obj == null ) {
			 return "";
		}
		return obj.toString();
	   }
}