package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import javax.persistence.*;

/**
 * 系统日志表
 */
@Entity
@Table(name = "RISK_SysLog")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class SysLog extends BaseBean {

	private static final long serialVersionUID = 1L;

	private Long object_id;

	private String object;

	private String logType;//日志类型（字典）
	
	private String content;

	private String exception;

	private String url;

	private String reqParam;

	private String userAgent;

	private String ip;

	private String method;
}
