package com.bcxin.risk.enums;

/**
 * @author hzp
 * 操作类型
 */
public enum OperateLogTypeEnum {

    LOGIN_IN("100","登录"),
    LOGIN_OUT("101","登出"),
    PAY_CONFIRM("200","确认支付"),
    PAY_DELAY("201","延后支付"),
    PAY_REFUND("202","退款"),
    CHECK_RECEIPT("301","审核发票"),
    OFFLINE_RECEIPT("302","线下开票");

    private String key;
    private String alias;

    OperateLogTypeEnum(String key,String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(OperateLogTypeEnum e : OperateLogTypeEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
