package com.bcxin.risk.compose.source;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 会展场馆
 * @author 070
 */
@Entity
@Table(name = "venue_exhibition")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class VenueExhibition extends VenueBase {

    /** 经度 */
    private String jingdu;

    /** 纬度 */
    private String weidu;

    /** 营业执照 */
    private String zhizhao;

    /** 组织机构代码证 */
    private String daimazheng;

    /** 税务登记证 */
    private String shuiwuzheng;

    /** 其他资质文件 */
    private String other;

    /** 总占地面积 */
    private String mianji;

    /** 总室内展厅面积 */
    private String jianzhu;

    /** 室外展场面积 */
    private String shiwaizhanchangmianji;

    /** 建筑面积 */
    private String jianzhumianji;

    /** 场地平面图 */
    private String photo;

    /** 座位总数 */
    private String zuowei;

    /** 固定座位/使用坐席 */
    private String gudingzuowei;

    /** 活动座位/使用坐席 */
    private String huodongzuowei;

    /** 可容纳人数 */
    private String people;

    /** 场馆介绍 */
    private String introduction;

    /** 区域位置 */
    private String adress;

    /** 经营范围 */
    private String jingying;

    /** 建筑结构 */
    private String jiegou;

}