package com.bcxin.risk.compose.source;

import com.bcxin.risk.base.domain.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 案例
 */
@Entity
@Table(name = "RISK_ComposeCase")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ComposeCase extends BaseBean {

	private static final long serialVersionUID = 1L;

    /**
     * 风险类型
     */
    private String type;

    /**
     * 案例发生时间
     */
    private String caseTime;

    /**
     * 适用活动类型
     */
    private String activityTypes;

    /**
     * 场地类型
     */
    private String venueTypes;

    /**
     * 事故类型
     */
    private String caseTypes;

    /**
     * 省
     */
    private Long provinceId;

    /**
     * 省名称
     */
    @Transient
    private String province;

    /**
     * 市
     */
    private Long cityId;

    /**
     * 市名称
     */
    @Transient
    private String city;

    /**
     * 区
     */
    private Long areaId;

    /**
     * 区名称
     */
    @Transient
    private String area;

    /**
     * 案例内容
     */
    private String content;


}
