package com.bcxin.risk.compose.dto;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WordContent implements Comparable<WordContent> {
	
	private int seq = 1000;

	private String content = "";
	
	private Set<String> style = new HashSet<String>();
	
	private WordContent parent;
	
	public static final List<String> ignore = new ArrayList<String>();
	
	static {
		ignore.add("<p>");
		ignore.add("<div>");
	}
	
	public int getSeq() {
		return seq;
	}
	public void setSeq(int seq) {
		this.seq = seq;
	}
	public String getContent() {
		return content;
	}
	public void setContent(String content) {
		if(content.startsWith("<img>&&") || content.startsWith("<table>&&")) {
			this.content = content;
		} else {
			this.content = content.replaceAll("<[a-z]*>", "");
		}
	}
	public Set<String> getStyle() {
		return style;
	}
	public void setStyle(Set<String> style) {
		this.style = style;
	}
	public WordContent getParent() {
		return parent;
	}
	public void setParent(WordContent parent) {
		this.parent = parent;
	}
	
	public void addStyle(String style) {
		if(!ignore.contains(style)) {
			this.style.add(style);
			if(this.parent != null) {
				parent.addStyle(style);
			}
		}
	}
	
	public static boolean validate(WordContent wordContent) {
		if(wordContent == null || (wordContent.getContent().trim().length() == 0 && wordContent.getStyle().size() == 0)) {
			return false;
		} else {
			return true;
		}
	}
	
	@Override
	public String toString() {
		return "WordContent [seq=" + seq + ", content=" + content + ", style=" + style + "]";
	}
	
	@Override
	public int compareTo(WordContent o) {
		if(this.seq > o.seq) {
			return 1;
		} else if(this.seq < o.seq) {
			return -1;
		} else {
			return 0;
		}
	}
	
}
