package com.bcxin.risk.common.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 搜索历史记录
 * @author 070
 */
@Entity
@Table(name = "RISK_SearchHistory")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class SearchHistory extends BaseBean {

    /**
     * 搜索内容
     */
    String keyName;

    /**
     *搜索类型 0 气候
     */
    String searchType;

    /**
     * 用户id
     */
    Long userId;
}
