package com.bcxin.risk.common.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 销售市场，可销售的区域
 * @author luopeng
 *
 */
@Entity
@Table(name = "SYS_MarketRegion")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class MarketRegion extends BaseBean {

	private static final long	serialVersionUID	= 1L;

	/**
	 * 省和直辖市
	 */
	private String province;

	/**
	 * 市/县
	 */
	private String city;

	/**
	 * 父级
	 */
	private Long parent_id;

	/**
	 * 层级
	 */
	private String level;

	/**
	 * 链接网站
	 */
	private String website;

	/**
	 * 平台名称
	 */
	private String platform;

	/**
	 * 独立网站（字典 0，1）
	 */
	private String independent;
}
