package com.bcxin.risk.base.domain.util;

import net.sf.json.JSONObject;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class DWZUtil {
	
	/**
	 * 返回 dwz 格式的json串（失败）
	 * 
	 * @param message
	 *            界面提示信息
	 * @param navTabId
	 *            重新载入标签页，如果无tabid参数，就载入当前标签页
	 * @param callbackType
	 *            callbackType如果是closeCurrent就会关闭当前tab
	 *            只有callbackType="forward"时需要forwardUrl值
	 * 
	 * @param forwardUrl
	 * @return JSON类型数据
	 */
	public static JSONObject returnFailedJson(String message,
			String navTabId,String callbackType,String forwardUrl) {
		Map<String, String> map = new HashMap<String, String>();
		map.put("statusCode", "300");
		map.put("message", message);
		map.put("navTabId", navTabId );
		map.put("callbackType", callbackType );
		map.put("forwardUrl", forwardUrl );
		return JSONObject.fromObject(map);
	}
	
	/**
	 * 返回 dwz 格式的json串（成功）
	 * 
	 * @param message
	 *            界面提示信息
	 * @param navTabId
	 *            重新载入标签页，如果无tabid参数，就载入当前标签页
	 * @param callbackType
	 *            callbackType如果是closeCurrent就会关闭当前tab
	 *            只有callbackType="forward"时需要forwardUrl值
	 * 
	 * @param forwardUrl
	 * @return JSON类型数据
	 */
	public static JSONObject returnSuccessJson(String message,
			String navTabId,String callbackType,String forwardUrl) {
		Map<String, String> map = new HashMap<String, String>();
		map.put("statusCode", "200");
		map.put("message", message);
		map.put("navTabId", navTabId );
		map.put("callbackType", callbackType );
		map.put("forwardUrl", forwardUrl );
		return JSONObject.fromObject(map);
	}
	
	
	public static void writer(HttpServletResponse response,Object data){
		PrintWriter writer;
		try {
			response.setCharacterEncoding("utf-8");
			writer = response.getWriter();
			writer.print(data);
			writer.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
}
