package com.bcxin.risk.base.domain;

import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * <b>基础类，所有domain的父类，提供主键、创建时间、修改时间 </b>
 * 
 * @author LuoPeng
 * @date 2016年12月14日 下午9:14:38
 * @注意事项 </b>
 * <b>
 */
@MappedSuperclass
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class BaseBean extends com.bcxin.risk.hibernateplus.entity.Convert implements Serializable {


	/**
	 * 主键
	 */
	@Id
	@GenericGenerator(name = "idGenerator", strategy = "native")
	@GeneratedValue(generator = "idGenerator")
	@Column(unique = true, nullable = false)
	private Long oid;
	
	/**
	 * 创建时间
	 */
	@Temporal(TemporalType.TIMESTAMP)
	private Date createOn;
	
	/**
	 * 修改时间
	 */
	@Temporal(TemporalType.TIMESTAMP)
	private Date updateOn;


}
