
package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.org.domain.Org;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.math.BigDecimal;


/**
 * 价格模板
 */
@Entity
@Table(name = "risk_Quotation")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert
@DynamicUpdate
public class Quotation extends BaseBean {

    //服务机构
    @ManyToOne(targetEntity = Org.class, fetch = FetchType.LAZY, cascade = CascadeType.PERSIST)
    @JoinColumn(name = "org_id")
    private Org org;

    private String name;//模板名称

    private BigDecimal maxQuote; //最高报价

    private BigDecimal minQuote; //最低报价

    /**
     * 定价分类（活动，酒店）
     */
    private String quotationClass;

    /**
     * 定价方式（字典，固定报价，参数报价，金额累加）
     */
    private String quotationType;

    /**
     * 目前适配的级别，市或区，允许值：2,3,2&3
     */
    private String quotationLevel;

    //是否激活
    private String active; //字典

}
