package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.order.OrderForm;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Date;

/**
 * 【活动】快递信息，（活动申报流程中纸质报告、发票信息[普票|增值税发票]）
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_ActivityExpress")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert
@DynamicUpdate
public class ActivityExpress extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**
	 * 订单
	 */
	@ManyToOne(targetEntity = OrderForm.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "orderForm_id")
	private OrderForm orderForm;

	/**
	 * 发票类型
	 */
	private String invoiceType;

	/**
	 * （字典） 不寄送，寄送报告
	 */
	private String reportExpressMode;

	/**
	 * （字典）不寄送，普通发票，增值税发票
	 */
	private String invoiceExpressMode;


	/**
	 * 发票和报告的收件人是否为同一人；1代表是，0代表不是
	 */
	private String expressSelf;


	/**
	 * 发票的抬头
	 */
	private String invoiceTitle;


	/**
	 * 公司单位名称
	 */
	private String companyNameInvoice;


	/**
	 * 纳税人识别号
	 */
	private String taxpayerNumberInvoice;

	/**
	 * 公司注册地址
	 */
	private String registerAddressInvoice;

	/**
	 * 单位联系方式
	 */
	private String contactPhoneInvoice;
	/**
	 * 开户银行
	 */
	private String bankInvoice;

	/**
	 * 开户银行账号
	 */
	private String bankAccountInvoice;


	/**
	 * 收票人姓名
	 */
	private String ticketName;
	/**
	 * 收票人电话
	 */
	private String ticketPhone;
	/**
	 * 收票人邮箱
	 */
	private String ticketEmail;

	/**
	 * 收票人地址
	 */
	private String ticketAddress;


	/**
	 * 一般纳税人证明
	 */
	private String tax_prove;

	/**
	 * 税务登记证
	 */
	private String tax_cert;


	/**
	 *  银行开户许可证
	 */
	private String bank_licence;

	/**
	 * 营业执照副本
	 */
	private String business_license;

	/**
	 * 增票授权委托书
	 */
	private String auth_cert;

	/**
	 * 审核意见
	 * 原来是remark
	 */
	private String comment;

	/**
	 * 快递公司 （字典）
	 */
	private String express;

	/**
	 * 快递单号
	 */
	private String expressNumber;

	@Temporal(TemporalType.TIMESTAMP)
	/**
	 * 快递时间
	 */
	private Date expressDate;

	/**
	 * 快递内容
	 */
	private String content;

	/**
	 *  审核状态（字典）
	 */
	private String approvalStatus;

	/**
	 * 电子发票开票结果
	 * 0代表未成功，1代表成功
	 */
	private String eInvoiceStatus;

	/**
	 * 电子发票
	 */
	private String eInvoicePdfUrl;

}
