/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.survey.domain;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.user.domain.ExpertUser;
import com.bcxin.risk.user.domain.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

@Entity
@Table(name="RISK_TASK")
@Inheritance(strategy=InheritanceType.JOINED)
@Proxy(proxyClass=Task.class)
@DynamicInsert(value=true)
@DynamicUpdate(value=true)
public class Task
extends BaseBean {
    private static final long serialVersionUID = 1L;
    @ManyToOne(targetEntity=Activity.class, fetch=FetchType.LAZY)
    @JoinColumn(name="activity_id")
    private Activity activity;
    private String name;
    @ManyToOne(targetEntity=User.class, fetch=FetchType.EAGER)
    @JoinColumn(name="assgin_id")
    private User assgin;
    @ManyToOne(targetEntity=ExpertUser.class, fetch=FetchType.EAGER)
    @JoinColumn(name="consultation_id")
    private ExpertUser consultation;
    @Column(name="assgin_id", updatable=false, insertable=false)
    private Long assginId;
    @JoinColumn(name="expert_id")
    private String expert_id;
    private String acceptStatus;
    private String taskStatus;
    private String taskType;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date acceptDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date finishDate;
    private String period;
    @Column(name="tk_config")
    private String tkConfig;
    @Column(name="zj_config")
    private String zjConfig;

    public String getMaxTKConfig(String tkConfig) {
        if (StringUtil.isEmpty(this.tkConfig)) {
            return "";
        }
        if (tkConfig.equals("TK03")) {
            return tkConfig;
        }
        if (tkConfig.equals("TK02") && this.tkConfig.equals("TK01")) {
            return tkConfig;
        }
        return this.tkConfig;
    }

    public int getTKConfigLeve() {
        if (StringUtil.isEmpty(this.tkConfig)) {
            return 0;
        }
        if (this.tkConfig.equals("TK03")) {
            return 3;
        }
        if (this.tkConfig.equals("TK02")) {
            return 2;
        }
        if (this.tkConfig.equals("TK01")) {
            return 1;
        }
        return 0;
    }

    public boolean isSurveyTask(String productCode) {
        if (StringUtil.isEmpty(this.tkConfig)) {
            return true;
        }
        if (this.tkConfig.equals("TK03")) {
            return false;
        }
        if (this.tkConfig.equals("TK02") && !productCode.equals("TK03")) {
            return false;
        }
        return !this.tkConfig.equals("TK01") || !productCode.equals("TK01");
    }

    public boolean isExpertType(String productCode) {
        if (StringUtil.isEmpty(this.zjConfig)) {
            return true;
        }
        return this.zjConfig.indexOf(productCode) < 0;
    }

    public Collection<String> getZJType() {
        ArrayList<String> zjType = new ArrayList<String>();
        if (StringUtil.isNotEmpty(this.zjConfig)) {
            if (this.zjConfig.indexOf("ZJ03") >= 0) {
                zjType.add("24");
            }
            if (this.zjConfig.indexOf("ZJ02") >= 0) {
                zjType.add("23");
            }
            if (this.zjConfig.indexOf("ZJ01") >= 0) {
                zjType.add("17");
            }
        }
        if (zjType.size() == 0) {
            return null;
        }
        return zjType;
    }

    @Generated
    public Task() {
    }

    @Generated
    public Activity getActivity() {
        return this.activity;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public User getAssgin() {
        return this.assgin;
    }

    @Generated
    public ExpertUser getConsultation() {
        return this.consultation;
    }

    @Generated
    public Long getAssginId() {
        return this.assginId;
    }

    @Generated
    public String getExpert_id() {
        return this.expert_id;
    }

    @Generated
    public String getAcceptStatus() {
        return this.acceptStatus;
    }

    @Generated
    public String getTaskStatus() {
        return this.taskStatus;
    }

    @Generated
    public String getTaskType() {
        return this.taskType;
    }

    @Generated
    public Date getAcceptDate() {
        return this.acceptDate;
    }

    @Generated
    public Date getFinishDate() {
        return this.finishDate;
    }

    @Generated
    public String getPeriod() {
        return this.period;
    }

    @Generated
    public String getTkConfig() {
        return this.tkConfig;
    }

    @Generated
    public String getZjConfig() {
        return this.zjConfig;
    }

    @Generated
    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setAssgin(User assgin) {
        this.assgin = assgin;
    }

    @Generated
    public void setConsultation(ExpertUser consultation) {
        this.consultation = consultation;
    }

    @Generated
    public void setAssginId(Long assginId) {
        this.assginId = assginId;
    }

    @Generated
    public void setExpert_id(String expert_id) {
        this.expert_id = expert_id;
    }

    @Generated
    public void setAcceptStatus(String acceptStatus) {
        this.acceptStatus = acceptStatus;
    }

    @Generated
    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }

    @Generated
    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    @Generated
    public void setAcceptDate(Date acceptDate) {
        this.acceptDate = acceptDate;
    }

    @Generated
    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    @Generated
    public void setPeriod(String period) {
        this.period = period;
    }

    @Generated
    public void setTkConfig(String tkConfig) {
        this.tkConfig = tkConfig;
    }

    @Generated
    public void setZjConfig(String zjConfig) {
        this.zjConfig = zjConfig;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$assginId = this.getAssginId();
        Long other$assginId = other.getAssginId();
        if (this$assginId == null ? other$assginId != null : !((Object)this$assginId).equals(other$assginId)) {
            return false;
        }
        Activity this$activity = this.getActivity();
        Activity other$activity = other.getActivity();
        if (this$activity == null ? other$activity != null : !((Object)this$activity).equals(other$activity)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        User this$assgin = this.getAssgin();
        User other$assgin = other.getAssgin();
        if (this$assgin == null ? other$assgin != null : !((Object)this$assgin).equals(other$assgin)) {
            return false;
        }
        ExpertUser this$consultation = this.getConsultation();
        ExpertUser other$consultation = other.getConsultation();
        if (this$consultation == null ? other$consultation != null : !((Object)this$consultation).equals(other$consultation)) {
            return false;
        }
        String this$expert_id = this.getExpert_id();
        String other$expert_id = other.getExpert_id();
        if (this$expert_id == null ? other$expert_id != null : !this$expert_id.equals(other$expert_id)) {
            return false;
        }
        String this$acceptStatus = this.getAcceptStatus();
        String other$acceptStatus = other.getAcceptStatus();
        if (this$acceptStatus == null ? other$acceptStatus != null : !this$acceptStatus.equals(other$acceptStatus)) {
            return false;
        }
        String this$taskStatus = this.getTaskStatus();
        String other$taskStatus = other.getTaskStatus();
        if (this$taskStatus == null ? other$taskStatus != null : !this$taskStatus.equals(other$taskStatus)) {
            return false;
        }
        String this$taskType = this.getTaskType();
        String other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !this$taskType.equals(other$taskType)) {
            return false;
        }
        Date this$acceptDate = this.getAcceptDate();
        Date other$acceptDate = other.getAcceptDate();
        if (this$acceptDate == null ? other$acceptDate != null : !((Object)this$acceptDate).equals(other$acceptDate)) {
            return false;
        }
        Date this$finishDate = this.getFinishDate();
        Date other$finishDate = other.getFinishDate();
        if (this$finishDate == null ? other$finishDate != null : !((Object)this$finishDate).equals(other$finishDate)) {
            return false;
        }
        String this$period = this.getPeriod();
        String other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !this$period.equals(other$period)) {
            return false;
        }
        String this$tkConfig = this.getTkConfig();
        String other$tkConfig = other.getTkConfig();
        if (this$tkConfig == null ? other$tkConfig != null : !this$tkConfig.equals(other$tkConfig)) {
            return false;
        }
        String this$zjConfig = this.getZjConfig();
        String other$zjConfig = other.getZjConfig();
        return !(this$zjConfig == null ? other$zjConfig != null : !this$zjConfig.equals(other$zjConfig));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Task;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $assginId = this.getAssginId();
        result = result * 59 + ($assginId == null ? 43 : ((Object)$assginId).hashCode());
        Activity $activity = this.getActivity();
        result = result * 59 + ($activity == null ? 43 : ((Object)$activity).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        User $assgin = this.getAssgin();
        result = result * 59 + ($assgin == null ? 43 : ((Object)$assgin).hashCode());
        ExpertUser $consultation = this.getConsultation();
        result = result * 59 + ($consultation == null ? 43 : ((Object)$consultation).hashCode());
        String $expert_id = this.getExpert_id();
        result = result * 59 + ($expert_id == null ? 43 : $expert_id.hashCode());
        String $acceptStatus = this.getAcceptStatus();
        result = result * 59 + ($acceptStatus == null ? 43 : $acceptStatus.hashCode());
        String $taskStatus = this.getTaskStatus();
        result = result * 59 + ($taskStatus == null ? 43 : $taskStatus.hashCode());
        String $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : $taskType.hashCode());
        Date $acceptDate = this.getAcceptDate();
        result = result * 59 + ($acceptDate == null ? 43 : ((Object)$acceptDate).hashCode());
        Date $finishDate = this.getFinishDate();
        result = result * 59 + ($finishDate == null ? 43 : ((Object)$finishDate).hashCode());
        String $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : $period.hashCode());
        String $tkConfig = this.getTkConfig();
        result = result * 59 + ($tkConfig == null ? 43 : $tkConfig.hashCode());
        String $zjConfig = this.getZjConfig();
        result = result * 59 + ($zjConfig == null ? 43 : $zjConfig.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Task(activity=" + this.getActivity() + ", name=" + this.getName() + ", assgin=" + this.getAssgin() + ", consultation=" + this.getConsultation() + ", assginId=" + this.getAssginId() + ", expert_id=" + this.getExpert_id() + ", acceptStatus=" + this.getAcceptStatus() + ", taskStatus=" + this.getTaskStatus() + ", taskType=" + this.getTaskType() + ", acceptDate=" + this.getAcceptDate() + ", finishDate=" + this.getFinishDate() + ", period=" + this.getPeriod() + ", tkConfig=" + this.getTkConfig() + ", zjConfig=" + this.getZjConfig() + ")";
    }
}

