/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.policy.enums;

import java.util.HashMap;
import java.util.Map;

public enum Gender {
    FEMALE("\u5973", "F", "0"),
    MALE("\u7537", "M", "1"),
    UNKNOWN("\u672a\u77e5", "N", "3");

    private String alias;
    private String value;
    private String code;
    private static Map<String, Gender> valueMap;
    private static boolean init;

    private Gender(String alias, String value, String code) {
        this.alias = alias;
        this.value = value;
        this.code = code;
    }

    private static void init() {
        for (Gender gender : Gender.values()) {
            valueMap.put(gender.value, gender);
            valueMap.put(gender.alias, gender);
            valueMap.put(gender.name(), gender);
            valueMap.put(gender.code, gender);
        }
        init = false;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getValue() {
        return this.value;
    }

    public String code() {
        return this.code;
    }

    public static Gender relation(String value) {
        if (init) {
            Gender.init();
        }
        return valueMap.get(value.trim());
    }

    static {
        valueMap = new HashMap<String, Gender>();
        init = true;
    }
}

