/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.policy.domain;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.DomainDateUtil;
import com.bcxin.risk.policy.domain.InsuranceProduct;
import com.bcxin.risk.policy.domain.MailPolicy;
import com.bcxin.risk.policy.domain.PlanSpec;
import com.bcxin.risk.policy.domain.RateSpec;
import com.bcxin.risk.policy.domain.RoleInPolicy;
import com.bcxin.risk.policy.enums.BeneficiaryMode;
import com.bcxin.risk.policy.enums.BenefitPeriodType;
import com.bcxin.risk.policy.enums.PaymentMode;
import com.bcxin.risk.policy.enums.PolicyStatus;
import com.bcxin.risk.policy.enums.PolicyType;
import com.bcxin.risk.policy.enums.RoleKind;
import com.bcxin.risk.policy.enums.SettlementStatus;
import com.bcxin.risk.report.enums.ExpressMode;
import com.bcxin.risk.user.domain.User;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="RISK_InsurancePolicy")
@Inheritance(strategy=InheritanceType.JOINED)
@DynamicInsert(value=true)
@DynamicUpdate(value=true)
public class InsurancePolicy
extends BaseBean {
    private static final long serialVersionUID = 1L;
    @ManyToOne(targetEntity=Activity.class, fetch=FetchType.LAZY)
    @JoinColumn(name="activity_id")
    private Activity activity;
    private String externalReference;
    @Enumerated(value=EnumType.STRING)
    private PolicyType policyType;
    private String policySerialNumber;
    @Temporal(value=TemporalType.DATE)
    private Date inceptionDate;
    @Temporal(value=TemporalType.DATE)
    private Date plannedEndDate;
    @Temporal(value=TemporalType.DATE)
    private Date htPlannedEndDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date signedDate;
    private BigDecimal premium = BigDecimal.ZERO;
    private BigDecimal discountRate = BigDecimal.ZERO;
    @Enumerated(value=EnumType.STRING)
    private PolicyStatus policyStatus;
    @Enumerated(value=EnumType.STRING)
    private BenefitPeriodType benefitPeriodType;
    private Integer benefitPeriod;
    @Enumerated(value=EnumType.STRING)
    private PaymentMode paymentMode = PaymentMode.SINGLE;
    @Enumerated(value=EnumType.STRING)
    private SettlementStatus settlementStatus = SettlementStatus.NO_SETTLEMENT;
    @Enumerated(value=EnumType.STRING)
    private BeneficiaryMode beneficiaryMode;
    @OneToOne(targetEntity=MailPolicy.class, cascade={CascadeType.ALL})
    @JoinColumn(name="mailPolicy_id")
    private MailPolicy mailPolicy = new MailPolicy();
    @ManyToOne(targetEntity=InsuranceProduct.class, fetch=FetchType.LAZY)
    @JoinColumn(name="spec_id")
    private InsuranceProduct insuranceProduct;
    @ManyToOne(targetEntity=PlanSpec.class, fetch=FetchType.LAZY)
    @JoinColumn(name="planSpec_id")
    private PlanSpec planSpec;
    @ManyToOne(targetEntity=RateSpec.class, fetch=FetchType.LAZY)
    @JoinColumn(name="rateSpec_id")
    private RateSpec rateSpec;
    @ManyToOne(targetEntity=User.class, fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    private User user;
    @Enumerated(value=EnumType.STRING)
    private ExpressMode expressMode;
    private String policyURL;
    @Transient
    private Map<String, RoleInPolicy> roleMap = new HashMap<String, RoleInPolicy>();
    @Transient
    private List<RoleInPolicy> roles = new ArrayList<RoleInPolicy>();

    public void addRole(RoleInPolicy r) {
        if (CollectionUtil.isEmpty(this.roles)) {
            this.roles.add(r);
        } else {
            ArrayList<RoleInPolicy> tempList = new ArrayList<RoleInPolicy>();
            tempList.addAll(this.roles);
            for (RoleInPolicy role : tempList) {
                String kind = role.getRoleKind().getKind();
                if (kind.equals(r.getRoleKind().getKind())) continue;
                this.roles.add(r);
            }
        }
    }

    @JsonIgnore
    public Map<String, RoleInPolicy> getRoleMap() {
        for (RoleInPolicy role : this.roles) {
            String kind = role.getRoleKind().getKind();
            if (this.roleMap.containsKey(kind)) continue;
            this.roleMap.put(kind, role);
        }
        return this.roleMap;
    }

    public RoleInPolicy getRoleOfKind(RoleKind kind) {
        for (RoleInPolicy role : this.roles) {
            if (!kind.equals((Object)role.getRoleKind())) continue;
            return role;
        }
        return null;
    }

    public Date getHtPlannedEndDate() {
        this.htPlannedEndDate = DomainDateUtil.addDay(this.plannedEndDate, 1);
        return this.htPlannedEndDate;
    }

    public void setHtPlannedEndDate(Date htPlannedEndDate) {
        this.htPlannedEndDate = htPlannedEndDate = DomainDateUtil.addDay(this.plannedEndDate, 1);
    }

    @Generated
    public InsurancePolicy() {
    }

    @Generated
    public Activity getActivity() {
        return this.activity;
    }

    @Generated
    public String getExternalReference() {
        return this.externalReference;
    }

    @Generated
    public PolicyType getPolicyType() {
        return this.policyType;
    }

    @Generated
    public String getPolicySerialNumber() {
        return this.policySerialNumber;
    }

    @Generated
    public Date getInceptionDate() {
        return this.inceptionDate;
    }

    @Generated
    public Date getPlannedEndDate() {
        return this.plannedEndDate;
    }

    @Generated
    public Date getSignedDate() {
        return this.signedDate;
    }

    @Generated
    public BigDecimal getPremium() {
        return this.premium;
    }

    @Generated
    public BigDecimal getDiscountRate() {
        return this.discountRate;
    }

    @Generated
    public PolicyStatus getPolicyStatus() {
        return this.policyStatus;
    }

    @Generated
    public BenefitPeriodType getBenefitPeriodType() {
        return this.benefitPeriodType;
    }

    @Generated
    public Integer getBenefitPeriod() {
        return this.benefitPeriod;
    }

    @Generated
    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    @Generated
    public SettlementStatus getSettlementStatus() {
        return this.settlementStatus;
    }

    @Generated
    public BeneficiaryMode getBeneficiaryMode() {
        return this.beneficiaryMode;
    }

    @Generated
    public MailPolicy getMailPolicy() {
        return this.mailPolicy;
    }

    @Generated
    public InsuranceProduct getInsuranceProduct() {
        return this.insuranceProduct;
    }

    @Generated
    public PlanSpec getPlanSpec() {
        return this.planSpec;
    }

    @Generated
    public RateSpec getRateSpec() {
        return this.rateSpec;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public ExpressMode getExpressMode() {
        return this.expressMode;
    }

    @Generated
    public String getPolicyURL() {
        return this.policyURL;
    }

    @Generated
    public List<RoleInPolicy> getRoles() {
        return this.roles;
    }

    @Generated
    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    @Generated
    public void setExternalReference(String externalReference) {
        this.externalReference = externalReference;
    }

    @Generated
    public void setPolicyType(PolicyType policyType) {
        this.policyType = policyType;
    }

    @Generated
    public void setPolicySerialNumber(String policySerialNumber) {
        this.policySerialNumber = policySerialNumber;
    }

    @Generated
    public void setInceptionDate(Date inceptionDate) {
        this.inceptionDate = inceptionDate;
    }

    @Generated
    public void setPlannedEndDate(Date plannedEndDate) {
        this.plannedEndDate = plannedEndDate;
    }

    @Generated
    public void setSignedDate(Date signedDate) {
        this.signedDate = signedDate;
    }

    @Generated
    public void setPremium(BigDecimal premium) {
        this.premium = premium;
    }

    @Generated
    public void setDiscountRate(BigDecimal discountRate) {
        this.discountRate = discountRate;
    }

    @Generated
    public void setPolicyStatus(PolicyStatus policyStatus) {
        this.policyStatus = policyStatus;
    }

    @Generated
    public void setBenefitPeriodType(BenefitPeriodType benefitPeriodType) {
        this.benefitPeriodType = benefitPeriodType;
    }

    @Generated
    public void setBenefitPeriod(Integer benefitPeriod) {
        this.benefitPeriod = benefitPeriod;
    }

    @Generated
    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    @Generated
    public void setSettlementStatus(SettlementStatus settlementStatus) {
        this.settlementStatus = settlementStatus;
    }

    @Generated
    public void setBeneficiaryMode(BeneficiaryMode beneficiaryMode) {
        this.beneficiaryMode = beneficiaryMode;
    }

    @Generated
    public void setMailPolicy(MailPolicy mailPolicy) {
        this.mailPolicy = mailPolicy;
    }

    @Generated
    public void setInsuranceProduct(InsuranceProduct insuranceProduct) {
        this.insuranceProduct = insuranceProduct;
    }

    @Generated
    public void setPlanSpec(PlanSpec planSpec) {
        this.planSpec = planSpec;
    }

    @Generated
    public void setRateSpec(RateSpec rateSpec) {
        this.rateSpec = rateSpec;
    }

    @Generated
    public void setUser(User user) {
        this.user = user;
    }

    @Generated
    public void setExpressMode(ExpressMode expressMode) {
        this.expressMode = expressMode;
    }

    @Generated
    public void setPolicyURL(String policyURL) {
        this.policyURL = policyURL;
    }

    @Generated
    public void setRoleMap(Map<String, RoleInPolicy> roleMap) {
        this.roleMap = roleMap;
    }

    @Generated
    public void setRoles(List<RoleInPolicy> roles) {
        this.roles = roles;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InsurancePolicy)) {
            return false;
        }
        InsurancePolicy other = (InsurancePolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$benefitPeriod = this.getBenefitPeriod();
        Integer other$benefitPeriod = other.getBenefitPeriod();
        if (this$benefitPeriod == null ? other$benefitPeriod != null : !((Object)this$benefitPeriod).equals(other$benefitPeriod)) {
            return false;
        }
        Activity this$activity = this.getActivity();
        Activity other$activity = other.getActivity();
        if (this$activity == null ? other$activity != null : !((Object)this$activity).equals(other$activity)) {
            return false;
        }
        String this$externalReference = this.getExternalReference();
        String other$externalReference = other.getExternalReference();
        if (this$externalReference == null ? other$externalReference != null : !this$externalReference.equals(other$externalReference)) {
            return false;
        }
        PolicyType this$policyType = this.getPolicyType();
        PolicyType other$policyType = other.getPolicyType();
        if (this$policyType == null ? other$policyType != null : !((Object)((Object)this$policyType)).equals((Object)other$policyType)) {
            return false;
        }
        String this$policySerialNumber = this.getPolicySerialNumber();
        String other$policySerialNumber = other.getPolicySerialNumber();
        if (this$policySerialNumber == null ? other$policySerialNumber != null : !this$policySerialNumber.equals(other$policySerialNumber)) {
            return false;
        }
        Date this$inceptionDate = this.getInceptionDate();
        Date other$inceptionDate = other.getInceptionDate();
        if (this$inceptionDate == null ? other$inceptionDate != null : !((Object)this$inceptionDate).equals(other$inceptionDate)) {
            return false;
        }
        Date this$plannedEndDate = this.getPlannedEndDate();
        Date other$plannedEndDate = other.getPlannedEndDate();
        if (this$plannedEndDate == null ? other$plannedEndDate != null : !((Object)this$plannedEndDate).equals(other$plannedEndDate)) {
            return false;
        }
        Date this$htPlannedEndDate = this.getHtPlannedEndDate();
        Date other$htPlannedEndDate = other.getHtPlannedEndDate();
        if (this$htPlannedEndDate == null ? other$htPlannedEndDate != null : !((Object)this$htPlannedEndDate).equals(other$htPlannedEndDate)) {
            return false;
        }
        Date this$signedDate = this.getSignedDate();
        Date other$signedDate = other.getSignedDate();
        if (this$signedDate == null ? other$signedDate != null : !((Object)this$signedDate).equals(other$signedDate)) {
            return false;
        }
        BigDecimal this$premium = this.getPremium();
        BigDecimal other$premium = other.getPremium();
        if (this$premium == null ? other$premium != null : !((Object)this$premium).equals(other$premium)) {
            return false;
        }
        BigDecimal this$discountRate = this.getDiscountRate();
        BigDecimal other$discountRate = other.getDiscountRate();
        if (this$discountRate == null ? other$discountRate != null : !((Object)this$discountRate).equals(other$discountRate)) {
            return false;
        }
        PolicyStatus this$policyStatus = this.getPolicyStatus();
        PolicyStatus other$policyStatus = other.getPolicyStatus();
        if (this$policyStatus == null ? other$policyStatus != null : !((Object)((Object)this$policyStatus)).equals((Object)other$policyStatus)) {
            return false;
        }
        BenefitPeriodType this$benefitPeriodType = this.getBenefitPeriodType();
        BenefitPeriodType other$benefitPeriodType = other.getBenefitPeriodType();
        if (this$benefitPeriodType == null ? other$benefitPeriodType != null : !((Object)((Object)this$benefitPeriodType)).equals((Object)other$benefitPeriodType)) {
            return false;
        }
        PaymentMode this$paymentMode = this.getPaymentMode();
        PaymentMode other$paymentMode = other.getPaymentMode();
        if (this$paymentMode == null ? other$paymentMode != null : !((Object)((Object)this$paymentMode)).equals((Object)other$paymentMode)) {
            return false;
        }
        SettlementStatus this$settlementStatus = this.getSettlementStatus();
        SettlementStatus other$settlementStatus = other.getSettlementStatus();
        if (this$settlementStatus == null ? other$settlementStatus != null : !((Object)((Object)this$settlementStatus)).equals((Object)other$settlementStatus)) {
            return false;
        }
        BeneficiaryMode this$beneficiaryMode = this.getBeneficiaryMode();
        BeneficiaryMode other$beneficiaryMode = other.getBeneficiaryMode();
        if (this$beneficiaryMode == null ? other$beneficiaryMode != null : !((Object)((Object)this$beneficiaryMode)).equals((Object)other$beneficiaryMode)) {
            return false;
        }
        MailPolicy this$mailPolicy = this.getMailPolicy();
        MailPolicy other$mailPolicy = other.getMailPolicy();
        if (this$mailPolicy == null ? other$mailPolicy != null : !((Object)this$mailPolicy).equals(other$mailPolicy)) {
            return false;
        }
        InsuranceProduct this$insuranceProduct = this.getInsuranceProduct();
        InsuranceProduct other$insuranceProduct = other.getInsuranceProduct();
        if (this$insuranceProduct == null ? other$insuranceProduct != null : !((Object)this$insuranceProduct).equals(other$insuranceProduct)) {
            return false;
        }
        PlanSpec this$planSpec = this.getPlanSpec();
        PlanSpec other$planSpec = other.getPlanSpec();
        if (this$planSpec == null ? other$planSpec != null : !((Object)this$planSpec).equals(other$planSpec)) {
            return false;
        }
        RateSpec this$rateSpec = this.getRateSpec();
        RateSpec other$rateSpec = other.getRateSpec();
        if (this$rateSpec == null ? other$rateSpec != null : !((Object)this$rateSpec).equals(other$rateSpec)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        ExpressMode this$expressMode = this.getExpressMode();
        ExpressMode other$expressMode = other.getExpressMode();
        if (this$expressMode == null ? other$expressMode != null : !((Object)((Object)this$expressMode)).equals((Object)other$expressMode)) {
            return false;
        }
        String this$policyURL = this.getPolicyURL();
        String other$policyURL = other.getPolicyURL();
        if (this$policyURL == null ? other$policyURL != null : !this$policyURL.equals(other$policyURL)) {
            return false;
        }
        Map<String, RoleInPolicy> this$roleMap = this.getRoleMap();
        Map<String, RoleInPolicy> other$roleMap = other.getRoleMap();
        if (this$roleMap == null ? other$roleMap != null : !((Object)this$roleMap).equals(other$roleMap)) {
            return false;
        }
        List<RoleInPolicy> this$roles = this.getRoles();
        List<RoleInPolicy> other$roles = other.getRoles();
        return !(this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InsurancePolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $benefitPeriod = this.getBenefitPeriod();
        result = result * 59 + ($benefitPeriod == null ? 43 : ((Object)$benefitPeriod).hashCode());
        Activity $activity = this.getActivity();
        result = result * 59 + ($activity == null ? 43 : ((Object)$activity).hashCode());
        String $externalReference = this.getExternalReference();
        result = result * 59 + ($externalReference == null ? 43 : $externalReference.hashCode());
        PolicyType $policyType = this.getPolicyType();
        result = result * 59 + ($policyType == null ? 43 : ((Object)((Object)$policyType)).hashCode());
        String $policySerialNumber = this.getPolicySerialNumber();
        result = result * 59 + ($policySerialNumber == null ? 43 : $policySerialNumber.hashCode());
        Date $inceptionDate = this.getInceptionDate();
        result = result * 59 + ($inceptionDate == null ? 43 : ((Object)$inceptionDate).hashCode());
        Date $plannedEndDate = this.getPlannedEndDate();
        result = result * 59 + ($plannedEndDate == null ? 43 : ((Object)$plannedEndDate).hashCode());
        Date $htPlannedEndDate = this.getHtPlannedEndDate();
        result = result * 59 + ($htPlannedEndDate == null ? 43 : ((Object)$htPlannedEndDate).hashCode());
        Date $signedDate = this.getSignedDate();
        result = result * 59 + ($signedDate == null ? 43 : ((Object)$signedDate).hashCode());
        BigDecimal $premium = this.getPremium();
        result = result * 59 + ($premium == null ? 43 : ((Object)$premium).hashCode());
        BigDecimal $discountRate = this.getDiscountRate();
        result = result * 59 + ($discountRate == null ? 43 : ((Object)$discountRate).hashCode());
        PolicyStatus $policyStatus = this.getPolicyStatus();
        result = result * 59 + ($policyStatus == null ? 43 : ((Object)((Object)$policyStatus)).hashCode());
        BenefitPeriodType $benefitPeriodType = this.getBenefitPeriodType();
        result = result * 59 + ($benefitPeriodType == null ? 43 : ((Object)((Object)$benefitPeriodType)).hashCode());
        PaymentMode $paymentMode = this.getPaymentMode();
        result = result * 59 + ($paymentMode == null ? 43 : ((Object)((Object)$paymentMode)).hashCode());
        SettlementStatus $settlementStatus = this.getSettlementStatus();
        result = result * 59 + ($settlementStatus == null ? 43 : ((Object)((Object)$settlementStatus)).hashCode());
        BeneficiaryMode $beneficiaryMode = this.getBeneficiaryMode();
        result = result * 59 + ($beneficiaryMode == null ? 43 : ((Object)((Object)$beneficiaryMode)).hashCode());
        MailPolicy $mailPolicy = this.getMailPolicy();
        result = result * 59 + ($mailPolicy == null ? 43 : ((Object)$mailPolicy).hashCode());
        InsuranceProduct $insuranceProduct = this.getInsuranceProduct();
        result = result * 59 + ($insuranceProduct == null ? 43 : ((Object)$insuranceProduct).hashCode());
        PlanSpec $planSpec = this.getPlanSpec();
        result = result * 59 + ($planSpec == null ? 43 : ((Object)$planSpec).hashCode());
        RateSpec $rateSpec = this.getRateSpec();
        result = result * 59 + ($rateSpec == null ? 43 : ((Object)$rateSpec).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        ExpressMode $expressMode = this.getExpressMode();
        result = result * 59 + ($expressMode == null ? 43 : ((Object)((Object)$expressMode)).hashCode());
        String $policyURL = this.getPolicyURL();
        result = result * 59 + ($policyURL == null ? 43 : $policyURL.hashCode());
        Map<String, RoleInPolicy> $roleMap = this.getRoleMap();
        result = result * 59 + ($roleMap == null ? 43 : ((Object)$roleMap).hashCode());
        List<RoleInPolicy> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "InsurancePolicy(activity=" + this.getActivity() + ", externalReference=" + this.getExternalReference() + ", policyType=" + (Object)((Object)this.getPolicyType()) + ", policySerialNumber=" + this.getPolicySerialNumber() + ", inceptionDate=" + this.getInceptionDate() + ", plannedEndDate=" + this.getPlannedEndDate() + ", htPlannedEndDate=" + this.getHtPlannedEndDate() + ", signedDate=" + this.getSignedDate() + ", premium=" + this.getPremium() + ", discountRate=" + this.getDiscountRate() + ", policyStatus=" + (Object)((Object)this.getPolicyStatus()) + ", benefitPeriodType=" + (Object)((Object)this.getBenefitPeriodType()) + ", benefitPeriod=" + this.getBenefitPeriod() + ", paymentMode=" + (Object)((Object)this.getPaymentMode()) + ", settlementStatus=" + (Object)((Object)this.getSettlementStatus()) + ", beneficiaryMode=" + (Object)((Object)this.getBeneficiaryMode()) + ", mailPolicy=" + this.getMailPolicy() + ", insuranceProduct=" + this.getInsuranceProduct() + ", planSpec=" + this.getPlanSpec() + ", rateSpec=" + this.getRateSpec() + ", user=" + this.getUser() + ", expressMode=" + (Object)((Object)this.getExpressMode()) + ", policyURL=" + this.getPolicyURL() + ", roleMap=" + this.getRoleMap() + ", roles=" + this.getRoles() + ")";
    }
}

