package com.bcxin.risk.user.dao.impl;

import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.user.dao.UserRoleDao;
import com.bcxin.risk.user.domain.User;
import com.bcxin.risk.user.domain.UserRole;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

/**
 *
 */
@Repository("userRole")
@SuppressWarnings("unchecked")
public class UserRoleDaoImpl extends DaoImpl<UserRole> implements UserRoleDao {

    @Override
    public void deleteUserRole(UserRole userRole){
        SelectWrapper wrapper = SelectWrapper.instance();
        if (userRole.getRole() != null){
            wrapper.eq("role_id", userRole.getRole().getOid());
        }
        if (userRole.getUser() != null){
            wrapper.eq("user_id", userRole.getUser().getOid());
        }
        delete(wrapper);
    }

    @Override
    public UserRole selectByUser(User user){
        List<Criterion> criterion = new ArrayList<Criterion>();
        criterion.add(Restrictions.eq("user_id", user));
        List<UserRole> list= this.selectList(criterion);
        if(list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Override
    public void insertUserRole(List<UserRole> userRoleList){

        String sql = "INSERT INTO risk_user_role (createOn,"+
                                                     "role_id,"+
                                                     "user_id)"+
                                           " VALUES ";
        for(UserRole userRole : userRoleList){
            sql += "(SYSDATE(),"+ userRole.getRole().getOid() +","+ userRole.getUser().getOid() +"),";
        }
        sql = sql.substring(0,sql.length()-1);
        executeSqlUpdate(sql);
    }

}
