package com.bcxin.risk.user.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.LongUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.org.domain.Org;
import com.bcxin.risk.user.dao.UserDao;
import com.bcxin.risk.user.domain.User;
import com.bcxin.risk.user.dto.data.*;
import com.bcxin.risk.user.dto.search.PoliceUserSearchDto;
import com.bcxin.risk.user.dto.search.UserRoleSearchDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;


@Repository("userDao")
public class UserDaoImpl extends DaoImpl<User> implements UserDao {

    @Override
    public User findUserByName(String name) {
        return selectOne(CriterionWrapper.instance().eq("userName", name));
    }

    @Override
    public User findUserByOid(long oid) {
        return selectById(oid);
    }

    @Override
    public List userList(DwzPage page, UserDto userDto) {

        String sql = "SELECT oid, DATE_FORMAT(createOn,'%Y-%m-%d %H:%i:%s') AS createOn,active,phone,"+
                "userName,realName,email,userType,org_id FROM risk_se_user WHERE 1=1 ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (userDto != null) {
            if (StringUtil.isNotEmpty(userDto.getUserName())) {
                sql = sql + " AND userName like '%"+userDto.getUserName()+"%' ";
            }
            if (StringUtil.isNotEmpty(userDto.getRealName())) {
                sql = sql + " AND realName = '"+userDto.getRealName()+"' ";
            }
            if (StringUtil.isNotEmpty(userDto.getPhone())) {
                sql = sql + " AND phone = '"+userDto.getPhone()+"' ";
            }
            if (StringUtil.isNotEmpty(userDto.getActive())) {
                sql = sql + " AND active = '"+userDto.getActive()+"' ";
            }
            if (StringUtil.isNotEmpty(userDto.getUserType())) {
                sql = sql + " AND userType = '"+userDto.getUserType()+"' ";
            }
        }
        if(page!= null ){
            page.setTotalCount(querySqlCounts( sql,  wrapper));
            sql = sql + " ORDER BY createOn DESC limit "+(page.getPageNum() - 1) * page.getNumPerPage()+","+page.getNumPerPage();
        }
        return  queryMaps( sql,  wrapper);
    }
	@Override
	public User findAdminUser() {
		// TODO Auto-generated method stub
        List<Criterion> criterion = Lists.newArrayList();

        criterion.add(Restrictions.eq("userType", DictConst.USERTYPE_GLJGYH));
        List list =  selectList(criterion);
        if (list.size()>0) {
            return (User) list.get(0);
        }
        return  null ;
	}

    // 查找角色关联的用户信息
    @Override
    public List<UserRoleDataDto> queryUserList(UserRoleSearchDto dto) {
         //查找角色相对应机构的用户
        Long oid = dto.getRole_id();
        String sql = "SELECT a.oid AS user_id," +
                             "a.userName," +
                             "a.realName," +
                             "a.userType," +
                             "(CASE WHEN b.orgType = '5' " +
                                    "THEN CONCAT(c.serviceOrgType,'0')"+
                                    "ELSE b.orgType END) AS orgType,"+
                             "(CASE WHEN (SELECT COUNT(1) " +
                                             "FROM risk_user_role " +
                                            "WHERE user_id = a.oid " +
                                              "AND role_id = "+ oid +")>0 " +
                                    "THEN 1 " +
                                    "ELSE 0 END) AS xzbz " +
                                    "FROM risk_se_user a, risk_org b " +
                                    "LEFT JOIN risk_serviceOrg c ON c.oid = b.oid  "+
                      "WHERE a.org_id = b.oid " +
                        "AND a.active = '1' "+
//                        "AND a.userType IN ('1','2','3','4','5') "+
                        "AND EXISTS (SELECT 1 " +
                                        "FROM risk_role " +
                                       "WHERE oid = "+ oid +
                                        " AND active = '1' "+
                                        " AND orgType = b.orgType " +
                                         "AND IFNULL(serviceOrgType,99) = IFNULL(c.serviceOrgType,99)) ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if(dto.getUserName()!= null){
            sql = sql + "AND a.userName like '%"+dto.getUserName()+"%' ";
        }
        wrapper.orderBy("a.oid", true);
        List<Map<String, Object>> list =  queryMaps( sql,  wrapper);
        List<UserRoleDataDto> dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map<String, Object> map = (Map<String, Object>) result;
            UserRoleDataDto userRoleDataDto = new UserRoleDataDto(map);
            dtoList.add(userRoleDataDto);
        });
        return dtoList ;
    }

    // 通过UserRoleSearchDto 查询用户、角色信息
    @Override
    public List<UserRoleDataDto> queryUserOrRoleList(UserRoleSearchDto dto) {
        //查找角色、用户信息
        String sql = "SELECT a.oid AS user_id," +
                             "a.userName," +
                             "a.realName," +
                             "a.userType," +
                             "a.email," +
                             "a.phone," +
                             "a.orgAdmin," +
                             "c.oid AS role_id," +
                             "c.roleCode," +
                             "c.roleName," +
                             "c.roleDesc " +
                "FROM risk_se_user a, risk_user_role b , risk_role c " +
                "WHERE a.oid = b.user_id " +
                  "AND b.role_id = c.oid "+
                  "AND a.active = '1' " +
                  "AND c.active = '1' ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if(StringUtil.isNotEmpty(dto.getRealName())){
            sql = sql + " AND a.realName like '%"+dto.getRealName()+"%' ";
        }
        if(StringUtil.isNotEmpty(dto.getUserName())){
            sql = sql + " AND a.userName = '"+dto.getUserName()+ "'";
        }
        if(StringUtil.isNotEmpty(dto.getRoleCode())){
            sql = sql + " AND c.roleCode = '"+dto.getRoleCode()+"'";
        }
        if(StringUtil.isNotEmpty(dto.getRoleName())){
            sql = sql + " AND c.roleName like '%"+dto.getRoleName()+"%' ";
        }
        if(dto.getUser_id() != null){
            sql = sql + " AND a.oid = "+ dto.getUser_id() ;
        }
        if(StringUtil.isNotEmpty(dto.getOrg_Id()) ){
            sql = sql + " AND a.org_id  = "+ dto.getOrg_Id() ;
        }
        if(dto.getRole_id()!= null){
            sql = sql + " AND c.oid = "+ dto.getRole_id() ;
        }
          sql = sql + " ORDER BY a.oid ,c.oid  ";
//        wrapper.orderBy("a.oid", true);
        List<Map<String, Object>> list =  queryMaps( sql,  wrapper);
        List<UserRoleDataDto> dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map<String, Object> map = (Map<String, Object>) result;
            UserRoleDataDto userRoleDataDto = new UserRoleDataDto(map);
            dtoList.add(userRoleDataDto);
        });
        return dtoList ;
    }

    /**
     * 根据角色和机构id，查找评估机构的创建的撰写用户
     * @param orgId
     * @param roleCode
     * @return
     */
    @Override
    public List<UserPlainDataDTO> findUserListByRole(long orgId,String roleCode){
        //查找角色、用户信息
        String sql = "SELECT a.phone,a.oid ," +
                " a.realName" +
                " FROM risk_se_user a, risk_user_role b , risk_role c " +
                " WHERE a.oid = b.user_id " +
                " AND b.role_id = c.oid "+
                " AND a.active = '1' " +
                " AND c.active = '1' ";
        SelectWrapper wrapper = SelectWrapper.instance();
        sql = sql + " AND c.roleCode = '"+ roleCode +"'";
        sql = sql + " AND a.org_id   = "+ orgId ;
        sql = sql + " ORDER BY a.oid ,c.oid  ";
        List<Map<String, Object>> list =  queryMaps( sql,  wrapper);
        List<UserPlainDataDTO> dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map<String, Object> map = (Map<String, Object>) result;
            UserPlainDataDTO dataDTO = new UserPlainDataDTO(map);
            dtoList.add(dataDTO);
        });
        return dtoList ;
    }

    @Override
    public List<MenuDataDto> queryMenuByUser(Long userId){

        String sql = "SELECT DISTINCT e.oid, " +
                " e.menuName," +
                " e.menuType " +
                " FROM risk_se_user a ,risk_user_role b, risk_role c ,risk_role_menu d, risk_menu e " +
                " WHERE a.oid = b.user_id " +
                " AND b.role_id = c.oid " +
                " AND c.oid = d.role_id " +
                " AND d.menu_id = e.oid " +
                " AND a.oid = " + userId +
                " ORDER BY e.oid ";

        List<Map<String,Object>>  list = queryMaps(sql);
        List<MenuDataDto> dtoList = Lists.newArrayList();
        list.forEach(result -> {
            MenuDataDto dto = new MenuDataDto(result);
            dtoList.add(dto);
        });
        return dtoList ;
    }

    /**
     * 通过用户机构来获取机构的第一个用户
      */
    @Override
    public UserDataDto findUserByOrgId(Long orgId) {
        String sql = " SELECT * " +
                      " FROM risk_se_user a " +
                      " WHERE a.active = " + DictConst.Y +
                      " and a.org_id = " + orgId ;
        List<Map<String,Object>>  list = queryMaps(sql);
        if (list != null) {
            UserDataDto dto = new UserDataDto(list.get(0));
            return dto;
        }
        return null;
    }

    //查询用户机构下的所有用户成员角色
    @Override
    public List<UserRoleDataDto> queryUserListByOrgId(User user, String name, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = " SELECT b.oid AS user_id," +
                "b.userName ," +
                "b.userType ," +
                "b.realName ," +
                "b.active ,"+
                "b.password ,"+
                "b.email ," +
                "b.phone ," +
                "d.oid as role_id, " +
                "case when (b.userType='14' or b.userType='16' or b.userType='17') " +
                "then (select expertName from risk_expert_type where expertType=b.userType)" +
                "else d.roleName end as roleName, " +
                "b.signature, "+
                "IFNULL((select checkStatus from risk_expertcheckinfo where userId=b.oid),0) as checkStatus " +
                "From " +
                "risk_serviceorg a," +
                "risk_se_user b," +
                "risk_user_role c," +
                "risk_role d  " +
                "WHERE" +
                " a.oid = b.org_Id" +
                " AND b.oid = c.user_id" +
                " AND c.role_id=d.oid" +
                " AND a.oid =" +user.getOrg().getOid()+" "+
                " AND b.oid != "+user.getOid()+" ";
        if (StringUtil.isNotEmpty(name)) {
            sql =sql + " AND b.userName like '%"+ name +"%' ";
        }
        wrapper.orderBy("b.oid", false);
        List<UserRoleDataDto> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            UserRoleDataDto dto = new UserRoleDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

     // 获取活动所在区域公安
     @Override
     public User findPoliceUserByArea(Long area_id) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty(area_id+"") ){
           // wrapper.eq("area_id", area_id);
        }
        criterionList.add(Restrictions.eq("userType", DictConst.USERTYPE_GAJGYH));
        List<User> userList = selectPage(criterionList, null);
//        User user = list.get(0);  //获取用户机构的第一条用户
        if ( CollectionUtil.isNotEmpty(userList) ) {
            return userList.get(0);
        }
        return new User();
    }

    // 更新用户
    @Override
     public int updateUser(User user){

        if (LongUtil.isNotEmpty(user.getCity_id())) {
            String sql = "Update risk_se_user " +
                    " SET city_id = '"+ user.getCity_id() + "' "+
                    " WHERE oid = "+user.getOid()  ;
            executeSqlUpdate(sql);
        }
        if (LongUtil.isNotEmpty(user.getArea_id())) {
            String sql = "Update risk_se_user " +
                    " SET area_id = '"+ user.getArea_id() + "' "+
                    " WHERE oid = "+user.getOid()  ;
            executeSqlUpdate(sql);
        }
        String sql = "Update risk_se_user " +
                     " SET phone = '" + user.getPhone() +"' , "+
                           "realName = '"+ user.getRealName() +"' , "+
                           "email = '"+ user.getEmail() +"' , "+
                "province_id = ";
        if (user.getProvince_id() == null || user.getProvince_id().toString() == "") {
            sql += null;
        } else {
            sql += "'" + user.getProvince_id() + "'";
        }

        sql += " , " + "updateOn = SYSDATE() " +
                   " WHERE oid = "+user.getOid()  ;
        return executeSqlUpdate(sql);
     }

    @Override
    public List findFrontUserList(UserDto userDto, DwzPage page){

        String sql = "SELECT  a.oid," +
                "DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn," +
                "a.active," +
                "a.phone,"+
                "a.userName," +
                "a.realName," +
                "a.email," +
                "a.userType," +
                "b.name AS orgName," +
                "b.govOrgFlag," +
                "(SELECT province FROM sys_region WHERE oid = a.province_id) AS province," +
                "(SELECT city FROM sys_region WHERE oid = a.city_id) AS city," +
                "(SELECT area FROM sys_region WHERE oid = a.area_id) AS area  " +
                "FROM risk_se_user a , risk_org b "+
                "WHERE a.org_id = b.oid " +
                "  AND a.userType IN ('1','2','5','7','8','9','10','11','20') ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (userDto != null) {
            if (StringUtil.isNotEmpty(userDto.getUserName())) {
                sql =  sql + " AND a.userName like '%"+userDto.getUserName()+"%'" ;
            }
            if (StringUtil.isNotEmpty(userDto.getRealName())) {
                sql =  sql + " AND a.realName like '%"+userDto.getRealName()+"%'" ;
            }
            if (StringUtil.isNotEmpty(userDto.getActive())) {
                sql =  sql + " AND a.active = '"+userDto.getActive()+"'" ;
            }
            if (StringUtil.isNotEmpty(userDto.getUserType())) {
                sql =  sql + " AND a.userType = '"+userDto.getUserType()+"'" ;
            }
            if (StringUtil.isNotEmpty(userDto.getGovOrgFlag())) {
                sql =  sql + " AND IFNULL(b.govOrgFlag,'0') = '"+userDto.getGovOrgFlag()+"' " ;
            }
            if (userDto.getArea_id()!= null ) {
                sql =  sql + " AND a.area_id = "+userDto.getArea_id() ;
            }
            if (userDto.getCity_id()!= null ) {
                sql =  sql + " AND a.city_id = "+userDto.getCity_id() ;
            }
            if (userDto.getProvince_id()!= null ) {
                sql =  sql + " AND a.province_id = "+userDto.getProvince_id() ;
            }
        }
        sql = sql + " ORDER BY a.oid DESC" ;
        if(page!= null ){
            page.setTotalCount(querySqlCounts( sql,  wrapper));
            sql = sql + " limit "+(page.getPageNum() - 1) * page.getNumPerPage()+","+page.getNumPerPage();
        }
        return  queryMaps( sql,  wrapper);

    }

    @Override
    public List<UserRoleDataDto>  findCashierByuserType(String usertypeGljgyhCw) {
        String sql = "SELECT a.oid AS user_id," +
                "a.userName," +
                "a.realName," +
                "a.userType," +
                "a.email," +
                "a.phone," +
                "a.orgAdmin," +
                "c.oid AS role_id," +
                "c.roleCode," +
                "c.roleName," +
                "c.roleDesc " +
                "FROM risk_se_user a, risk_user_role b , risk_role c " +
                "WHERE a.oid = b.user_id " +
                "AND b.role_id = c.oid "+
                "AND a.active = '1' " +
                "AND c.active = '1' ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (StringUtil.isNotEmpty(usertypeGljgyhCw)) {
            sql =  sql + " AND a.userType = '"+usertypeGljgyhCw+"' " ;
        }

        sql = sql + " ORDER BY a.oid DESC" ;
        List<UserRoleDataDto> dtoList = Lists.newArrayList();
        List<Map<String, Object>> list = queryMaps(sql, wrapper);
        list.forEach(result -> {
            UserRoleDataDto dto = new UserRoleDataDto(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public List<User> findUserListByDto(UserDto dto) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty(dto.getActive())) {
            criterionList.add(Restrictions.eq("active",dto.getActive()));
        }
        criterionList.add(Restrictions.or(Restrictions.eq("isSync", DictConst.N),Restrictions.isNull("isSync")));
        if (StringUtil.isNotEmpty(dto.getOid())) {
            criterionList.add(Restrictions.eq("oid", dto.getOid()));
        }
        Order order = Order.desc("oid");
        return selectList(criterionList,order);
    }

    @Override
    public List<PoliceUserDataDto> findPoliceUser(PoliceUserSearchDto dto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select oid , DATE_FORMAT(createOn, '%Y-%m-%d %H:%i:%s') AS createOn, province_id , city_id ," +
                "        area_id , realName , userName ,  phone , email , active  " +
                "    from risk_se_user where 1=1 and  userType = '3'  ";

        if(StringUtil.isNotEmpty(dto.getProvince())){
            sql += " and province_id = '"+ dto.getProvince() + "' ";
        }
        if(StringUtil.isNotEmpty(dto.getCity())){
            sql += " and city_id = '"+ dto.getCity() + "' ";
        }
        if(StringUtil.isNotEmpty(dto.getArea()) ){
            sql += " and area_id  = '"+ dto.getArea() + "' ";
        }
        if(StringUtil.isNotEmpty(dto.getNotnull()) ){
            sql += " and "+dto.getNotnull()+" is NOT NULL ";
        }
        if(StringUtil.isNotEmpty(dto.getName()) ){
            sql = sql + "AND realName like '%"+ dto.getName()+"%' ";
        }
        wrapper.orderBy("createOn",false);
        wrapper.orderBy("oid",false);
        List<PoliceUserDataDto> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            PoliceUserDataDto policeUserDataDto = new PoliceUserDataDto(result);
            policeUserDataDto.setPage(page);
            dtoList.add(policeUserDataDto);
        });
        return dtoList;
    }

    /**
     *
     * @param orgId
     * @param name
     * @return
     */
    @Override
    //查询用户机构下的所有用户
    public List<UserRoleDataDto> queryUserList(Long orgId ,String name,Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = " SELECT b.oid AS user_id," +
                              "b.userName ," +
                              "b.realName ," +
                              "b.active ,"+
                              "b.password ,"+
                              "b.email ," +
                              "b.phone ," +
                              "b.userType ," +
                              "b.signature "+
                "FROM risk_serviceorg a,risk_se_user b " +
                "WHERE a.oid = b.org_Id" +
                 " AND a.oid =" + orgId +" ";
        if (StringUtil.isNotEmpty(name)) {
            sql =sql + " AND b.userName like '%"+ name +"%' ";
        }
        wrapper.orderBy("b.oid", false);
        List<UserRoleDataDto> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            UserRoleDataDto dto = new UserRoleDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }


    @Override
    public List<UserRoleDataDto> findAssessmentManageUser(long orgId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select " +
                " u.phone," +
                " u.email" +
                " from risk_se_user u\n" +
                " inner join risk_user_role ur on ur.user_id = u.oid\n" +
                " inner join risk_role r on r.oid = ur.role_id\n" +
                " where (\n" +
                "    (u.userType = 5 and r.roleCode = '"+DictConst.USERROLE_PGJG+"')\n" +
                " or (u.userType = 8 and r.roleCode = '"+DictConst.USERROLE_ZG+"')\n" +
                "       )\n" +
                " and u.org_id =  " + orgId +
                " and u.active = " + DictConst.Y ;
        List<UserRoleDataDto> dtoList = Lists.newArrayList();
        List<Map<String, Object>> list = queryMaps(sql, wrapper);
        list.forEach(result -> {
            UserRoleDataDto dto = new UserRoleDataDto(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public List<UserPlainDataDTO> findUserListByOrgAndUserType(Long orgId, String userType) {
        //查找角色、用户信息
        StringBuffer sql = new StringBuffer("SELECT a.oid,a.realName");
        if(DictConst.USERTYPE_DSFFWJGYH_ZXZJ.equals(userType)) {
            sql.append(",re.expertCategory ");
        }
        sql.append(" FROM risk_se_user a ");
        if(DictConst.USERTYPE_DSFFWJGYH_ZXZJ.equals(userType)) {
            sql.append("INNER JOIN risk_expertuser re on a.oid=re.oid");
            sql.append(" and re.checkStatus= "+ DictConst.CHECKSTATUS_PASS );
        }
        sql.append(" WHERE a.active = '1'");
        sql.append(" AND a.userType = '"+ userType +"'");
        sql.append(" AND a.org_id = "+ orgId );
        sql.append(" ORDER BY a.oid");
        SelectWrapper wrapper = SelectWrapper.instance();
        List<Map<String, Object>> list =  queryMaps(sql.toString(), wrapper);
        List<UserPlainDataDTO> dtoList = Lists.newArrayList();
        list.forEach(map -> {
            UserPlainDataDTO dataDTO = new UserPlainDataDTO(map);
            dtoList.add(dataDTO);
        });
        return dtoList ;
    }

    /**
     * 根据机构id和类型查找用户
     * @param orgId
     * @param userType
     * @return
     */
    @Override
    public List<User> findUserByOrgIdAndUserType(Long orgId, String userType){
        List<Criterion> criterions = new ArrayList<Criterion>();
        criterions.add(Restrictions.eq("active", DictConst.Y));
        criterions.add(Restrictions.eq("userType", userType));
        if(orgId != null) {
            criterions.add(Restrictions.eq("org.oid", orgId));
        }
        return this.selectList(criterions);
    }

    @Override
    public List<User> findByListOid(List<Long> list){
        List<Criterion> criterions = new ArrayList<Criterion>();
        criterions.add(Restrictions.in("oid", list));
        return this.selectList(criterions);
    }

    @Override
    public int countUserByType(String userType) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT a.oid from risk_se_user a INNER JOIN risk_expertuser b ON a.oid = b.oid AND b.checkStatus = '2' AND a.userType = '" + userType + "' AND a.active ='1'" ;
        List<Map<String, Object>> list = queryMaps(sql, wrapper);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    @Override
    public User selectUserByUserName(String userName) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("userName", userName));
        List<User> list=selectList(criterionList);
        if(list==null || list.isEmpty()){
            return null;
        }
        return list.get(0);
    }

    /**
     * 验证用户名是否存在
     * @param userName
     * @return
     */
    @Override
    public boolean existsUserName(String userName){
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("userName", userName));
        List list= selectList(criterionList);
        if(list==null || list.isEmpty()){
            return false;
        }
        return true;
    }

    @Override
    public int correlate(User user) {
        if (StringUtil.isNotEmpty(user.getEsignId())) {
            String sql = "Update risk_se_user " +
                    " SET esignId = '"+ user.getEsignId() + "' "+
                    " WHERE oid = "+user.getOid()  ;
            executeSqlUpdate(sql);
        }
        return 0;
    }

    /**
     * 根据机构Id 和人员类型查询人员
     *
     * @param oid
     * @return
     */
    @Override
    public List<User> selectServiceOrgPerson(String userType, Long oid) {
        List<Criterion> criterion = Lists.newArrayList();
        criterion.add(Restrictions.eq("org.oid", oid));
        criterion.add(Restrictions.eq("userType", userType));
        criterion.add(Restrictions.eq("active", DictConst.Y));
        return this.selectList(criterion);
    }

    @Override
    public User selectUserByComId(String comId) {
        List<Criterion> criterion = new ArrayList<Criterion>();
        criterion.add(Restrictions.eq("comId", comId));
        criterion.add(Restrictions.in("userType",Arrays.asList(DictConst.USERTYPE_GOV,DictConst.USERTYPE_CBDWYH,DictConst.USERTYPE_DSFFWJGYH)));
        List<User> list= this.selectList(criterion);
        if (list == null || list.isEmpty()) {
            return null;
        }
        User user=null;
        for(User u : list) {
            if (ObjectUtil.equal(u.getUserType(), DictConst.USERTYPE_GOV)
                    || ObjectUtil.equal(u.getUserType(), DictConst.USERTYPE_CBDWYH)
                    || ObjectUtil.equal(u.getUserType(), DictConst.USERTYPE_DSFFWJGYH)) {
                user = u;
                break;
            }
        }
        return user;
    }

    @Override
    public User selectUserByComId(String userType, String comId) {
        List<Criterion> criterion = new ArrayList<Criterion>();
        criterion.add(Restrictions.eq("comId", comId));
        criterion.add(Restrictions.eq("userType", userType));
        List<User> list= this.selectList(criterion);
        if(list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }
    @Override
    public User selectUserByPerId(String perId) {
        List<Criterion> criterion = new ArrayList<Criterion>();
        criterion.add(Restrictions.eq("perId", perId));
        List<User> list= this.selectList(criterion);
        if(list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }
    @Override
    public User selectUserByComIdAndUserName(String userName, String comId) {
        List<Criterion> criterion = new ArrayList<Criterion>();
        criterion.add(Restrictions.eq("comId", comId));
        criterion.add(Restrictions.eq("userName", userName));
        List<User> list= this.selectList(criterion);
        if(list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Override
    public User selectUserByComIdAndPhone(String phone, String comId) {
        List<Criterion> criterion = new ArrayList<Criterion>();
        criterion.add(Restrictions.eq("comId", comId));
        criterion.add(Restrictions.eq("phone", phone));
        List<User> list= this.selectList(criterion);
        if(list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<User> selectServiceOrgPersonByList(List<String> userTypeList, Long oid) {
        List<Criterion> criterion = new ArrayList<Criterion>();
        criterion.add(Restrictions.eq("org.oid", oid));
        criterion.add(Restrictions.in("userType", userTypeList));
        criterion.add(Restrictions.eq("active", DictConst.Y));
        return this.selectList(criterion);
    }

    /**
     * 查询服务机构注册人员，第一个注册
     *
     * @param org
     * @return
     */
    @Override
    public User selectServiceOrgRegister(Org org) {
        List<Criterion> criterion = Lists.newArrayList();
        criterion.add(Restrictions.eq("org", org));
        criterion.add(Restrictions.eq("active", DictConst.Y));
        List list = selectList(criterion);
        if (list.size() > 0) {
            return (User) list.get(0);
        }
        return null;
    }

    @Override
    public List<User> selectUserListByList(List<Long> expertIdList) {
        List<Criterion> criterion = new ArrayList<>();
        criterion.add(Restrictions.in("oid", expertIdList));
        criterion.add(Restrictions.eq("active", DictConst.Y));
        return this.selectList(criterion);
    }
}
