package com.bcxin.risk.user.dao.impl;

import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.org.domain.Org;
import com.bcxin.risk.user.dao.ServiceOrgUserDao;
import com.bcxin.risk.user.domain.ServiceOrgUser;
import com.bcxin.risk.user.dto.search.ServiceOrgUserSearchDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository("serviceOrgUserDao")
@SuppressWarnings("unchecked")
public class ServiceOrgUserDaoImpl extends DaoImpl<ServiceOrgUser> implements ServiceOrgUserDao {

    @Override
    public ServiceOrgUser findOrgUserByName(String name) {
        return selectOne(CriterionWrapper.instance().eq("userName", name));
    }

    @Override
    public ServiceOrgUser findOrgUserByOrg(Org org) {
        return selectOne(CriterionWrapper.instance().eq("org", org));
    }
    public ServiceOrgUser findServiceOrgUserByOid(Long oid){
        return selectById(oid);
    }
    @Override
    public List<ServiceOrgUser> findServiceOrgUserList(ServiceOrgUserSearchDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (searchDto.getOrg() != null) {
            criterionList.add(Restrictions.eq("serviceOrg", searchDto.getOrg()));
        }
        if (page == null) {
            return selectList(criterionList);
        }
        return selectPage(criterionList, page);
    }
}
