package com.bcxin.risk.user.dao.impl;

import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.dao.RoleMenuDao;
import com.bcxin.risk.user.domain.RoleMenu;
import com.bcxin.risk.user.dto.search.RoleMenuSearchDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository("roleMenuDao")
@SuppressWarnings("unchecked")
public class RoleMenuDaoImpl extends DaoImpl<RoleMenu> implements RoleMenuDao {


    @Override
    public List findMenuIdyRoleId(Long roleId, Page page) {
        String sql = "SELECT menu_id FROM risk_role_menu ";
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("role_id", roleId);
       return queryMaps( sql,  wrapper);
    }

    public RoleMenu findRoleMenuByOid(Long oid){
        return selectById(oid);
    }
    @Override
    public List<RoleMenu> findRoleMenuList(RoleMenuSearchDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (searchDto.getRole() != null) {
            criterionList.add(Restrictions.eq("user", searchDto.getRole()));
        }
        if (searchDto.getMenu() != null) {
            criterionList.add(Restrictions.eq("menu", searchDto.getMenu()));
        }
        if (page == null) {
            return selectList(criterionList);
        }
        return selectPage(criterionList, page);
    }

    public void insertRoleMenu(List<RoleMenu> roleMenuList){
        String sql = "INSERT INTO risk_role_menu (createOn,"+
                                                     "menu_id,"+
                                                     "role_id)"+
                                            " VALUES ";
        for(RoleMenu roleMenu : roleMenuList){
           sql += "(SYSDATE(),"+ roleMenu.getMenu_id() +","+ roleMenu.getRole_id() +"),";
        }
        sql = sql.substring(0,sql.length()-1);
        executeSqlUpdate(sql);
    }

    public List<RoleMenu> queryRoleMenu(){
        String sql = "SELECT m.oid," +
                "       m.createOn," +
                "       m.updateOn," +
                "       m.role_id," +
                "       m.menu_id" +
                "  FROM " +
                "(SELECT a.*,  " +
                "       IF(@last_deptno = a.role_id, @rn \\:= @rn + 1, @rn\\:= 1) AS rn,  " +
                "       @last_deptno \\:= a.role_id AS last_deptno  " +
                "  FROM risk_role_menu a  " +
                " WHERE a.role_id in(29,33) " +
                " ORDER BY oid )m ,(select @rn\\:=0,@last_deptno\\:=0) as b " +
                "WHERE m.rn <= 3" ;;
        List<RoleMenu>  roleMenuList =  selectListBySql(sql);
        return roleMenuList;
    }



    public void deleteRoleMenu(RoleMenu roleMenu){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("role_id", roleMenu.getRole_id());
        delete(wrapper);
    }
}
