package com.bcxin.risk.user.dao.impl;

import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.dao.ContractorUserDao;
import com.bcxin.risk.user.domain.ContractorUser;
import com.bcxin.risk.user.dto.search.ContractorUserSearchDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository("contractorUserDao")
@SuppressWarnings("unchecked")
public class ContractorUserDaoImpl extends DaoImpl<ContractorUser> implements ContractorUserDao {

    @Override
    public ContractorUser findContractorUserByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public ContractorUser findUserByName(String name) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("userName", name));
        List list = selectList(criterionList);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return (ContractorUser)list.get(0);
    }

    @Override
    public void updateFirstLogin(ContractorUser contractorUser) {

        String sql = "UPDATE risk_contractoruser SET isFirstLogin ='0' WHERE org_id = ' " + contractorUser.getOrg().getOid() + " '";
        executeSqlUpdate(sql);
    }

    @Override
    public ContractorUser selectContractor(Long org_id) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("org_id", org_id);
        return selectOne(wrapper);
    }

    @Override
    public List<ContractorUser> findContractorUserList(ContractorUserSearchDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getOrg() != null ) {
            criterionList.add(Restrictions.eq("org", searchDto.getOrg()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }

}
