package com.bcxin.risk.ticket;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.ticket.domain.BarriergateUser;
import com.bcxin.risk.ticket.dto.search.BarriergateUserSearchDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class BarriergateUserDaoImpl extends DaoImpl<BarriergateUser> implements BarriergateUserDao{

    @Override
    public BarriergateUser findBarriergateUserByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<BarriergateUser> findBarriergateUserList(BarriergateUserSearchDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();

        if (StringUtil.isNotEmpty(searchDto.getExid()) ) {
            criterionList.add(Restrictions.eq("exid", searchDto.getExid()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }
}
