package com.bcxin.risk.ticket;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.ticket.domain.BarriergateEntryInfo;
import com.bcxin.risk.ticket.dto.search.BarriergateEntryInfoSearchDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class BarriergateEntryInfoDaoImpl extends DaoImpl<BarriergateEntryInfo> implements BarriergateEntryInfoDao {
    @Override
    public BarriergateEntryInfo findBarriergateEntryInfoByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<BarriergateEntryInfo> findBarriergateEntryInfoList(BarriergateEntryInfoSearchDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty(searchDto.getEntranceno()) ) {
            criterionList.add(Restrictions.eq("entranceno", searchDto.getEntranceno()));
        }
        if (StringUtil.isNotEmpty(searchDto.getEntryarea()) ) {
            criterionList.add(Restrictions.eq("entryarea", searchDto.getEntryarea()));
        }
        if (StringUtil.isNotEmpty(searchDto.getEntrydate()) ) {
            criterionList.add(Restrictions.eq("entrydate", searchDto.getEntrydate()));
        }
        if (StringUtil.isNotEmpty(searchDto.getEntrytime()) ) {
            criterionList.add(Restrictions.eq("entrytime", searchDto.getEntrytime()));
        }
        if (StringUtil.isNotEmpty(searchDto.getExid()) ) {
            criterionList.add(Restrictions.eq("exid", searchDto.getExid()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }
}
